/**
 * LICENCSE + COPYRIGHT
 */
package org.vcs.bazaar.client;

import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import java.util.Map;

import org.vcs.bazaar.client.commandline.commands.options.Option;
import org.vcs.bazaar.client.commandline.internal.CommandRunner;
import org.vcs.bazaar.client.core.BazaarClientException;
import org.vcs.bazaar.client.core.BranchLocation;

/**
 * @author Guillermo Gonzalez
 *
 */
public abstract class BazaarClient implements IBazaarClient {

	protected File workDir;
	protected IBazaarPromptUserPassword userPasswordPrompt;

	public final void setWorkDir(final File workDir) {
		this.workDir = workDir;
	}

	public void addPasswordCallback(IBazaarPromptUserPassword callback) {
		userPasswordPrompt = callback;
	}

	/**
	 * Get the preferences shared by all clients
	 *
	 * @return BazaarClientPreferences
	 */
	public static final BazaarClientPreferences getPreferences() {
		return BazaarClientPreferences.getInstance();
	}

	protected abstract CommandRunner getCommandRunner();

	public InputStream cat(File file, IBazaarRevisionSpec revision, Option... options) throws BazaarClientException {
		return cat(file, revision, null, options);
	}

	public void move(File orig, File dest, Option... options) throws BazaarClientException {
		move(new File[] { orig }, dest, options);
	}

	public Map<String, List<IBazaarLogMessage>> missing(File workdir, URI otherBranch, Option... options) throws BazaarClientException {
		return missing(workdir, new BranchLocation(otherBranch), options);
	}

	public void pull(URI location, Option... options) throws BazaarClientException {
		pull(new BranchLocation(location), options);
	}

	public void push(URI location, Option... options) throws BazaarClientException {
		push(new BranchLocation(location), options);
	}

	public BazaarRevision revno(File location) throws BazaarClientException {
		return revno(new BranchLocation(location));
	}

	public IBazaarInfo info(File location, Option... options) throws BazaarClientException {
		return info(new BranchLocation(location), options);
	}

	protected void notImplementedYet() throws BazaarClientException {
		throw new BazaarClientException("Not implemented");
	}
}
