/**
 * LICENCSE + COPYRIGHT
 */
package org.vcs.bazaar.client;

import java.io.File;
import java.io.Serializable;
import java.util.Collection;

/**
 * @author Guillermo Gonzalez
 *
 */
public interface IBazaarStatus extends Serializable {

	public String getShortStatus();

	/**
	 * @return a String representing the relative (to branch root) path to the
	 *         file
	 */
	public String getPath();

	/**
	 * @return a String representing the relative (to branch root) previous path
	 *         to the file
	 */
	public String getPreviousPath();

	public String getOldKind();

	public String getNewKind();

	/**
	 * @return a File which stands for the absolute path to the branch
	 */
	public File getBranchRoot();

	/**
	 * @return a File binded to this status (which is relative to branch root)
	 */
	public File getFile();

	/**
	 * @return the previous File binded to this status (which is relative to
	 *         branch root)
	 */
	public File getPreviousFile();

	/**
	 * @return a String which contains the absolute path to this status file
	 */
	public String getAbsolutePath();

	/**
	 *
	 * @param a
	 *            {@link BazaarStatusKind}
	 * @return true if this status conatins the given {@link BazaarStatusKind}
	 */
	public boolean contains(BazaarStatusKind kind);

	/**
	 * Return a Collection with all the {@link BazaarStatusKind} that belongs to
	 * this status object
	 *
	 * @return Collection<? extends BazaarStatusKind>
	 */
	public Collection<? extends BazaarStatusKind> getStatuses();

	public boolean equals(Object obj);

	public int hashCode();

	boolean isDirectory(); 
}
