/**
 * LICENCSE + COPYRIGHT
 */
package org.vcs.bazaar.client.commandline;

import org.vcs.bazaar.client.BazaarClientFactory;
import org.vcs.bazaar.client.IBazaarClient;
import org.vcs.bazaar.client.core.BazaarClientException;

/**
 * @author Guillermo Gonzalez
 *
 */
public class CommandLineClientFactory extends BazaarClientFactory {

	public static final String CLIENT_TYPE = "CommandLine";

	/*
	 * (non-Javadoc)
	 *
	 * @see org.vcs.bazaar.client.BazaarClientFactory#createClientImpl()
	 */
	@Override
	protected IBazaarClient createClientImpl() {
		return new CommandLineClient(new CommandLineNotificationHandler());
	}

	/*
	 * (non-Javadoc)
	 *
	 * @see org.vcs.bazaar.client.BazaarClientFactory#getClientType()
	 */
	@Override
	protected String getClientType() {
		return CLIENT_TYPE;
	}

	public static void setup(boolean force) throws BazaarClientException {
		if (!CommandLineClient.isAvailable(force)) {
			throw new BazaarClientException("Command line client is not available");
		}
		BazaarClientFactory.registerAdapterFactory(new CommandLineClientFactory());
	}

}
