/**
 * LICENCSE + COPYRIGHT
 */
package org.vcs.bazaar.client.commandline;

import org.vcs.bazaar.client.core.BazaarClientException;

/**
 * @author Guillermo Gonzalez
 *
 */
public class CommandLineException extends BazaarClientException {

	private static final long serialVersionUID = -8645734268757666362L;

	private static final int ERROR = 0;
	private static final int INFO = 1;
	private final String command;

	public CommandLineException(final String message, final String command) {
		super(message);
		this.command = command;
	}

	public CommandLineException(final Throwable cause, final String command) {
		super(cause.getMessage(), cause);
		this.setStackTrace(cause.getStackTrace());
		this.command = command;
	}

	public static CommandLineException wrapException(final Exception e) {
		return new CommandLineException(e, "");
	}

	public String getMessageError() {
		final String[] message = getMessage().split(System.getProperty("line.separator"));
		String error = message[ERROR];
		return error;
	}

	public String getMessageInfo() {
		final String[] message = getMessage().split(System.getProperty("line.separator"));
		if (message.length > INFO)
			return message[INFO];
		return getMessage();
	}

	@Override
	public String getCommand() {
		return command;
	}

	@Override
	public boolean isCommandLine() {
		return true;
	}
}
