/**
 * LICENSE + COPYRIGHT
 */
package org.vcs.bazaar.client.commandline.commands;

import java.io.File;
import java.net.URI;

import org.vcs.bazaar.client.commandline.syntax.ILogOptions;
import org.vcs.bazaar.client.core.BranchLocation;

/**
 * @author Guillermo Gonzalez
 *
 */
public class Log extends SingleFileOrLocationCommand implements ILogOptions {

	public Log(final File workDir, final File resource) {
		super(workDir, resource);
	}

	public Log(final File workDir, final URI location) {
		super(workDir, location);
	}

	public Log(final File workDir, final BranchLocation location) {
		super(workDir, location);
	}

	@Override
	public String getCommand() {
		return COMMAND;
	}

}
