/**
 * LICENSE + COPYRIGHT
 */
package org.vcs.bazaar.client.commandline.commands;

import java.io.File;
import java.util.List;

import org.vcs.bazaar.client.commandline.syntax.IMergeOptions;
import org.vcs.bazaar.client.core.BranchLocation;

/**
 * @author Guillermo Gonzalez <guillo.gonzo AT gmail DOT com>
 *
 */
public class Merge extends SingleFileCommand {

	private final BranchLocation location;

	public Merge(final File workDir, final BranchLocation location) {
		super(workDir, null);
		this.location = location;
	}

	@Override
	protected List<String> getArguments() {
		return getArguments(location.toString());
	}

	public String getCommand() {
		return IMergeOptions.COMMAND;
	}

}
