/**
 * LICENSE + COPYRIGHT
 */
package org.vcs.bazaar.client.commandline.commands;

import java.io.File;
import java.util.List;

import org.vcs.bazaar.client.commandline.syntax.IMissingOptions;
import org.vcs.bazaar.client.core.BranchLocation;

/**
 * @author Guillermo Gonzalez
 *
 */
public class Missing extends SingleFileCommand implements IMissingOptions {

	final private BranchLocation location;

	public Missing(final File workDir, final BranchLocation otherBranch) {
		super(workDir, null);
		this.location = otherBranch;
	}

	@Override
	protected List<String> getArguments() {
		return getArguments(location.toString());
	}

	public String getCommand() {
		return COMMAND;
	}

}