/**
 * LICENSE + COPYRIGHT
 */
package org.vcs.bazaar.client.commandline.commands;

import java.io.File;
import java.util.List;

import org.vcs.bazaar.client.commandline.CommandLineException;
import org.vcs.bazaar.client.commandline.internal.CommandRunner;
import org.vcs.bazaar.client.commandline.syntax.IMoveOptions;
import org.vcs.bazaar.client.core.BazaarClientException;

/**
 * @author Guillermo Gonzalez
 *
 */
public class Move extends MultiFileCommand implements IMoveOptions {

	private final File toPath;

	public Move(final File workDir, final File[] files, final File toPath) {
		super(workDir, files);
		this.toPath = toPath;
	}

	/*
	 * (non-Javadoc)
	 *
	 * @see org.vcs.bazaar.client.core.commands.Command#execute()
	 */
	@Override
	public void execute(CommandRunner runner) throws BazaarClientException {
		if (checkArguments()) {
			super.execute(runner);
		} else {
			throw new CommandLineException("unexpected arguments", getCommand());
		}
	}

	/*
	 * (non-Javadoc)
	 *
	 * @see org.vcs.bazaar.client.core.commands.Command#getArguments()
	 */
	@Override
	protected List<String> getArguments() {
		List<String> args = super.getArguments();
		args.add(toPath.getAbsolutePath());
		return args;
	}

	/*
	 * (non-Javadoc)
	 *
	 * @see org.vcs.bazaar.client.core.commands.Command#getCommand()
	 */
	@Override
	public String getCommand() {
		return COMMAND;
	}

	// helpers
	private boolean checkArguments() {
		if (resources.length > 1) {
			return toPath.isDirectory();
		}
		return true;
	}

}
