/**
 * LICENSE + COPYRIGHT
 */
package org.vcs.bazaar.client.commandline.commands;

import java.io.File;
import java.util.List;

import org.vcs.bazaar.client.commandline.syntax.IPullOptions;
import org.vcs.bazaar.client.core.BranchLocation;

/**
 * @author Guillermo Gonzalez
 *
 */
public class Pull extends SingleFileCommand implements IPullOptions {

	final private BranchLocation location;

	public Pull(final File workDir, final BranchLocation location) {
		super(workDir, null);
		this.location = location;
	}

	/*
	 * (non-Javadoc)
	 *
	 * @see org.vcs.bazaar.client.core.commands.Command#getArguments()
	 */
	@Override
	protected List<String> getArguments() {
		return getArguments(location.toString());
	}

	/*
	 * (non-Javadoc)
	 *
	 * @see org.vcs.bazaar.client.commandline.internal.Command#getCommand()
	 */
	public String getCommand() {
		return COMMAND;
	}

}
