/**
 * LICENSE + COPYRIGHT
 */
package org.vcs.bazaar.client.commandline.commands;

import java.io.File;
import java.util.List;

import org.vcs.bazaar.client.commandline.syntax.IPushOptions;
import org.vcs.bazaar.client.core.BranchLocation;

/**
 * @author Guillermo Gonzalez
 *
 */
public class Push extends SingleFileCommand implements IPushOptions {

	private BranchLocation location;

	public Push(File workDir, BranchLocation location) {
		super(workDir);
		this.location = location;
	}

	@Override
	protected List<String> getArguments() {
		return getArguments(location.toString());
	}

	@Override
	public String getCommand() {
		return COMMAND;
	}

}
