/**
 * LICENCSE + COPYRIGHT
 */
package org.vcs.bazaar.client.commandline.commands;

import java.io.File;
import java.util.List;

import org.vcs.bazaar.client.commandline.syntax.IRebaseOptions;
import org.vcs.bazaar.client.core.BranchLocation;

/**
 * @author Piotr Piastucki
 */
public class Rebase extends SingleFileCommand implements IRebaseOptions {

	private final BranchLocation location;

	public Rebase(final File workDir, final BranchLocation location) {
		super(workDir, null);
		this.location = location;
	}
	
	@Override
	protected List<String> getArguments() {
		return getArguments(location.toString());
	}

	public String getCommand() {
		return COMMAND;
	}
	
}
