/**
 * LICENCSE + COPYRIGHT
 */
package org.vcs.bazaar.client.commandline.commands;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

import org.vcs.bazaar.client.commandline.syntax.IRevnoOptions;
import org.vcs.bazaar.client.core.BranchLocation;

/**
 * @author Guillermo Gonzalez
 *
 */
public class Revno extends SingleFileCommand implements IRevnoOptions {

	private String location;

	public Revno(final File workDir, final BranchLocation location) {
		super(workDir);
		this.location = location.toString();
	}

	protected List<String> getArguments() {
		List<String> args = new ArrayList<String>();
		args.add(location);
		return args;
	}
	/*
	 * (non-Javadoc)
	 *
	 * @see org.vcs.bazaar.client.core.model.ICommand#getCommandName()
	 */
	@Override
	public String getCommand() {
		return COMMAND;
	}

	public String getStandardOutput() {
		return super.getStandardOutputSplit()[0].trim();
	}

}
