/**
 * LICENCSE + COPYRIGHT
 */
package org.vcs.bazaar.client.commandline.commands;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

import org.vcs.bazaar.client.commandline.internal.Command;

/**
 * <p>
 * An abstract class which define some common behaivor for commands who operate
 * over a single file/directory
 * </p>
 *
 * @author Guillermo Gonzalez
 */
public abstract class SingleFileCommand extends Command {

	protected final File file;

	protected SingleFileCommand(File workDir, File file) {
		super(workDir);
		this.file = file;
	}

	protected SingleFileCommand(File workDir) {
		super(workDir);
		this.file = null;
	}

	/*
	 * (non-Javadoc)
	 *
	 * @see org.vcs.bazaar.client.core.commands.Command#getArguments()
	 */
	@Override
	protected List<String> getArguments() {

		List<String> args = new ArrayList<String>();

		if (file != null) {
			args.add(getRelativeToWorkDir(file).getPath());
		}

		return args;
	}

}
