/**
 * LICENSE + COPYRIGHT
 */
package org.vcs.bazaar.client.commandline.commands;

import java.io.File;
import java.util.List;

import org.vcs.bazaar.client.commandline.CommandLineException;
import org.vcs.bazaar.client.commandline.internal.Command;
import org.vcs.bazaar.client.commandline.syntax.ITagOptions;

/**
 * @author Piotr Piastucki
 */
public class Tag extends Command implements ITagOptions {

	private final String tagName;

	public Tag(File workDir, String tagName) {
		super(workDir);
		this.tagName = tagName;
	}

	@Override
	public String getCommand() {
		return COMMAND;
	}

	@Override
	protected List<String> getArguments() throws CommandLineException {
		return getArguments(tagName);
	}
}
