package org.vcs.bazaar.client.commandline.internal;

import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.util.List;

import org.vcs.bazaar.client.BazaarClientPreferences;
import org.vcs.bazaar.client.commandline.CommandLineException;
import org.vcs.bazaar.client.utils.Assert;
import org.vcs.bazaar.client.utils.StreamRedirect;

public class ShellCommandRunner extends CommandRunner {

	public ShellCommandRunner(boolean checkExitValue) {
		super(checkExitValue);
	}

	@Override
	public void runCommand(final Command command, final File workDir) throws IOException, InterruptedException, CommandLineException {
		final List<String> cmdLine = command.constructCommandInvocationString();
		Assert.isNotNull(cmdLine);
		Assert.isTrue(cmdLine.size() > 0);
		cmdLine.addAll(0, BazaarClientPreferences.getExecutable(true));
		StringWriter outStream = new StringWriter();
		StringWriter errStream = new StringWriter();
		ProcessBuilder pb = new ProcessBuilder(cmdLine);
		setDefaultEnviroment(pb);
		if (workDir != null) {
			pb.directory(workDir);
		}
		Process proc = pb.start();
		String outName = "output_redirect"; //$NON-NLS-1$
		String errName = "error_redirect"; //$NON-NLS-1$
		StreamRedirect outRedirect = new StreamRedirect(outName, proc.getInputStream(), outStream);
		StreamRedirect errRedirect = new StreamRedirect(errName, proc.getErrorStream(), errStream);

		outRedirect.start();
		errRedirect.start();
		try {
			// wait for command to finish
			proc.waitFor();
			// wait until out stream content is redirected
			outRedirect.join();
			errRedirect.join();
		} catch (InterruptedException e) {
			throw e;
		}
		if (checkExitValue && proc.exitValue() != 0) {
			IOException e = new IOException(errStream.toString());
			e.setStackTrace(CommandLineException.getCurrentStackTrace());
			stderr = errStream.toString();
			throw e;
		} else {
			proc.exitValue();
		}
		stderr = errStream.toString();
		stdout = outStream.toString();
	}

	@Override
	protected String getSplitExpression() {
		return System.getProperty("line.separator");
	}

}
