/**
 * LICENSE + COPYRIGHT
 */
package org.vcs.bazaar.client.commandline.parser;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;

import org.kxml2.io.KXmlParser;
import org.vcs.bazaar.client.BazaarShelf;
import org.vcs.bazaar.client.IBazaarShelf;
import org.vcs.bazaar.client.core.BazaarClientException;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

/**
 * @author Piotr Piastucki
 */
public class XMLShelveListParser extends XMLParser {

	private static final String SHELVES = "shelves";
	private static final String SHELF = "shelf";
	private static final String ID = "id";
	private final static String MESSAGE = "message";

	public static List<IBazaarShelf> parse(String xml) throws BazaarClientException {
		KXmlParser parser = new KXmlParser();
		try {
			parser.setInput(new StringReader(xml));
			return new XMLShelveListParser().parse(parser);
		} catch (XmlPullParserException e) {
			throw BazaarClientException.wrapException(e);
		}
	}

	public List<IBazaarShelf> parse(KXmlParser aParser) throws BazaarClientException {
		List<IBazaarShelf> shelves = new ArrayList<IBazaarShelf>();
		parser = aParser;
		try {
			parser.nextTag();
			parser.require(KXmlParser.START_TAG, null, SHELVES);
			int eventType = parser.getEventType();
			while (eventType != XmlPullParser.END_DOCUMENT
					&& !(eventType == XmlPullParser.END_TAG && SHELVES.equals(parser.getName()))) {
				if (eventType == XmlPullParser.START_TAG && SHELF.equals(parser.getName())) {
					IBazaarShelf shelf = parseShelf();
					if (shelf != null) {
						shelves.add(shelf);
					}
				}
				eventType = parser.next();
			}
			return shelves;
		} catch (XmlPullParserException e) {
			throw BazaarClientException.wrapException(e);
		} catch (IOException e) {
			throw BazaarClientException.wrapException(e);
		}
	}

	private IBazaarShelf parseShelf() throws XmlPullParserException, IOException {
		String id = null;
		String message = null;
		int eventType = parser.next();
		while (eventType != XmlPullParser.END_DOCUMENT
				&& !(eventType == XmlPullParser.END_TAG && SHELF.equals(parser.getName()))) {
			if (eventType == XmlPullParser.START_TAG && ID.equals(parser.getName())) {
				id = parser.nextText();
			} else if (eventType == XmlPullParser.START_TAG && MESSAGE.equals(parser.getName())) {
				message = parser.nextText();
			}
			eventType = parser.next();
		}
		return new BazaarShelf(id, message);
	}

}
