/**
 * LICENCSE + COPYRIGHT
 */
package org.vcs.bazaar.client.commandline.syntax;

import org.vcs.bazaar.client.commandline.commands.options.KeywordOption;
import org.vcs.bazaar.client.commandline.commands.options.Option;
/**
 * @author Piotr Piastucki
 */
public interface IShelveOptions {

	public final static String COMMAND = "shelve"; //$NON-NLS-N$

	/**
	 * Shelve all text changes at once.
	 */
	public static final Option ALL = new Option("--all"); //$NON-NLS-N$

	/**
	 * Display more information.
	 */
	public static final Option VERBOSE = new Option("--verbose"); //$NON-NLS-N$

	/**
	 * List previously-shelved changes.
	 */
	public static final Option LIST = new Option("--list"); //$NON-NLS-N$

	/**
	 * Only display errors and warnings.
	 */
	public static final Option QUIET = new Option("--quiet"); //$NON-NLS-N$

	/**
	 * Description of the new shelf.
	 */
	public static final KeywordOption MESSAGE = new KeywordOption("--message", "ARG"); //$NON-NLS-N$

	public static final Option MESSAGE_SHORT = new Option("-m"); //$NON-NLS-N$

	public final static String HELP = "Temporarily set aside some changes from the current tree."; //$NON-NLS-N$

}
