/**
 *
 */
package org.vcs.bazaar.client.xmlrpc;

import java.util.Map;

import org.vcs.bazaar.client.IBzrError;
import org.vcs.bazaar.client.xmlrpc.parser.XMLErrorParser;

/**
 * @author Guillermo Gonzalez <guillo.gonzo AT gmail DOT com>
 *
 */
public class BzrXmlRpcError implements IBzrError {

	Map<String, String> dict;
	String message;
	String type;

	public static IBzrError fromXml(String stdErrXml) {
		if(stdErrXml == null || "".equals(stdErrXml.trim()))
			return null;
		return new XMLErrorParser().parse(stdErrXml);
	}

	public BzrXmlRpcError(Map<String, String> dict, String message, String type) {
		super();
		this.dict = dict;
		this.message = message;
		this.type = type;
	}

	public Map<String, String> getDict() {
		return dict;
	}

	public String getMessage() {
		return message;
	}

	public String getType() {
		return type;
	}

}
