/**
 *
 */
package org.vcs.bazaar.client.xmlrpc;

import org.vcs.bazaar.client.commandline.CommandLineClient;
import org.vcs.bazaar.client.commandline.CommandLineNotificationHandler;
import org.vcs.bazaar.client.commandline.internal.Command;
import org.vcs.bazaar.client.commandline.internal.CommandRunner;
import org.vcs.bazaar.client.core.BazaarClientException;
import org.vcs.bazaar.client.xmlrpc.internal.XMLRPCCommandRunner;

/**
 * @author Guillermo Gonzalez <guillo.gonzo AT gmail DOT com>
 *
 */
public class XmlRpcClient extends CommandLineClient {

	public XmlRpcClient(final CommandLineNotificationHandler notificationHandler) {
		super(notificationHandler);
	}

	@Override
	protected CommandRunner getCommandRunner() {
		return new XMLRPCCommandRunner(true);
	}
	
	public void execute(Command command) throws BazaarClientException {
		this.run(command);
	}

	public Object execute(XmlRpcMethod method) throws BazaarClientException {
		return ((XMLRPCCommandRunner)getCommandRunner()).executeMethod(method);
	}

	public void stopXmlRpcService() throws BazaarClientException {
		execute(new XmlRpcMethod("quit"));
	}

	public static boolean isAvailable(boolean force) throws BazaarClientException {
		// TODO: Add connectivity check (i.e. start up xmlrpc server and ping it)
		return CommandLineClient.isAvailable(force);
	}

}
