/**
 * LICENCSE + COPYRIGHT
 */
package org.vcs.bazaar.client.xmlrpc;

import org.vcs.bazaar.client.BazaarClientFactory;
import org.vcs.bazaar.client.IBazaarClient;
import org.vcs.bazaar.client.commandline.CommandLineNotificationHandler;
import org.vcs.bazaar.client.core.BazaarClientException;

/**
 * @author Guillermo Gonzalez
 *
 */
public class XmlRpcClientFactory extends BazaarClientFactory {

	public static final String CLIENT_TYPE = "XmlRpcClient";

	/*
	 * (non-Javadoc)
	 *
	 * @see org.vcs.bazaar.client.BazaarClientFactory#createClientImpl()
	 */
	@Override
	protected IBazaarClient createClientImpl() {
		return new XmlRpcClient(new CommandLineNotificationHandler());
	}

	/*
	 * (non-Javadoc)
	 *
	 * @see org.vcs.bazaar.client.BazaarClientFactory#getClientType()
	 */
	@Override
	protected String getClientType() {
		return CLIENT_TYPE;
	}

	public static void setup(boolean force) throws BazaarClientException {
		if (!XmlRpcClient.isAvailable(force)) {
			throw new BazaarClientException("XMLRPC based client is not available");
		}
		BazaarClientFactory.registerAdapterFactory(new XmlRpcClientFactory());
	}

}
