/**
 *
 */
package org.vcs.bazaar.client.xmlrpc.internal;

import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;

import org.vcs.bazaar.client.BazaarClientPreferences;
import org.vcs.bazaar.client.BazaarPreference;
import org.vcs.bazaar.client.IBzrError;
import org.vcs.bazaar.client.commandline.internal.CommandRunner;
import org.vcs.bazaar.client.core.BazaarClientException;
import org.vcs.bazaar.client.utils.StreamRedirect;
import org.vcs.bazaar.client.xmlrpc.XmlRpcCommandException;

import redstone.xmlrpc.XmlRpcArray;
import redstone.xmlrpc.XmlRpcException;

public class XMLRPCServer implements Runnable {

	private static final int SLEEP_TIME = 200;
	private static final String START_XMLRPC = "start-xmlrpc";
	private static final String PORT_OPTION = "--port=";
	private static Process xmlRpcService;
	private String port;
	private final StringWriter serviceStdErr;

	static class ServerKiller extends Thread {
		public void run() {
			try {
				XMLRPCServer.destroy();
			} catch (Exception ex) {}
		}
	}


	public XMLRPCServer() {
		super();
		serviceStdErr = new StringWriter();
		Runtime.getRuntime().addShutdownHook(new ServerKiller());
	}

	public void run() {
		try {
			if(testConnection()) {
				// there is an instance of the SERVICE already running
				return;
			}
		} catch (XmlRpcCommandException e) {
			final IBzrError error = e.getCommandError();
			if(error!=null && error.getType().equals("unknown") && error.getMessage().contains("Broken pipe")) {
				destroy();
			}
		}

		final List<String> args = new ArrayList<String>();
		args.addAll(BazaarClientPreferences.getExecutable(true));
		args.add(START_XMLRPC);
		port = BazaarClientPreferences.getInstance().getString(BazaarPreference.BZR_XMLRPC_PORT);
		if(this.port != null && !"".equals(this.port)) {
			args.add(PORT_OPTION + this.port);
		}
		final ProcessBuilder pb = CommandRunner.createProcessBuilderWith(args);
		try {
			xmlRpcService = pb.start();
			final StreamRedirect srout = new StreamRedirect("xmlrpc-service_stdout>null", xmlRpcService.getInputStream(), null);
			final StreamRedirect srerr = new StreamRedirect("xmlrpc-service_stderr>null", xmlRpcService.getErrorStream(), serviceStdErr);

			srout.start();
			srerr.start();

			boolean connect = false;
			while(!connect) {
				connect = isConnected();
				try {
					if(!connect && !isConnected()) {
						xmlRpcService.exitValue();
						throw new BazaarClientException.BazaarUncheckedException(serviceStdErr.toString());
					}
				} catch (IllegalThreadStateException e) {
					Thread.sleep(SLEEP_TIME);
				}
			}

		} catch (IOException ioex) {
			throw new RuntimeException(ioex);
		} catch (InterruptedException intex) {
			throw new RuntimeException(intex);
		}
	}

	private static boolean isConnected() throws InterruptedException {
		try {
			return testConnection();
		} catch (BazaarClientException ioex) {
			Thread.sleep(SLEEP_TIME);
		}
		return false;
	}

	private static boolean testConnection() throws XmlRpcCommandException {
		try {
			final String result = (String)XMLRPCCommandRunner.executeMethod("hello", new XmlRpcArray());
			if(result != null && result.equals("world!")) {
				return true;
			}
			return false;
		} catch(XmlRpcException e) {
			return false;
		}

	}

	public static boolean isAlive() {
		if (xmlRpcService == null) {
			// just in case there is a zombie server around
			destroy();
			return false;
		}
		try {
			if(!testConnection()) {
				// if the process have exit value, it's finished
				xmlRpcService.exitValue();
				return false;
			}
			return true;
		} catch (IllegalThreadStateException  e) {
			// if the Process object has not yet terminated.
			return true;
		} catch (XmlRpcCommandException e) {
			return false;
		}
	}

	public static void destroy() {
		try {
			XMLRPCCommandRunner.executeMethod("quit", new XmlRpcArray());
		} catch (Exception ex) {
		} finally {
			if(xmlRpcService != null) {
				xmlRpcService.destroy();
			}
		}
	}

	public String getPort() {
		return port;
	}
}