package org.vcs.bazaar.client.commandline.parser;

import static org.junit.Assert.assertEquals;

import org.junit.Test;

public class XMLParserTest {

	@Test
	public void testGetDeclaredEncoding() {
	    
		assertEquals("Should return encoding declared in the XML Header", "ISO-8859-1", XMLParser.getDeclaredEncoding("<?xml encoding=\"ISO-8859-1\"?><hello></hello>"));
		assertEquals("Should return encoding declared in the XML Header", "UTF-8", XMLParser.getDeclaredEncoding("<?xml version=\"1.0\" encoding=\"UTF-8\"?><hello></hello>"));
		
		assertEquals("Should return null if the XML declaration is not the first content", null, XMLParser.getDeclaredEncoding("<!-- Invalid XML --><?xml version=\"1.0\" encoding=\"UTF-8\"?><hello></hello>"));
		assertEquals("Should return null if no encoding declaration is found", null, XMLParser.getDeclaredEncoding("This is not XML, or has no encoding declaration"));
		assertEquals("Should return null if the string to check is null", null, XMLParser.getDeclaredEncoding(null));
	}

}
