/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.client.commandline.commands;

import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import org.vcs.bazaar.client.BazaarClientPreferences;
import org.vcs.bazaar.client.BazaarPreference;
import org.vcs.bazaar.client.IPlugin;
import org.vcs.bazaar.client.commandline.CommandLineException;
import org.vcs.bazaar.client.commandline.commands.Plugins;
import org.vcs.bazaar.client.commandline.internal.CommandRunner;
import org.vcs.bazaar.client.commandline.internal.ShellCommandRunner;
import org.vcs.bazaar.client.commandline.parser.XMLPluginParser;
import org.vcs.bazaar.client.testUtils.BazaarTest;

public class PluginsTest
extends BazaarTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public final void testBadPluginsPath() throws Exception {
        BazaarClientPreferences prefs = BazaarClientPreferences.getInstance();
        String old = prefs.getString(BazaarPreference.BZR_PLUGIN_PATH);
        prefs.set(BazaarPreference.BZR_PLUGIN_PATH, "foo/bar");
        Plugins cmd = new Plugins();
        try {
            cmd.execute((CommandRunner)new ShellCommandRunner(true));
        }
        catch (CommandLineException e) {
            Assert.assertEquals((Object)"xmlplugins", (Object)e.getCommand());
        }
        finally {
            prefs.set(BazaarPreference.BZR_PLUGIN_PATH, old);
        }
    }

    @Test
    public final void testDefaultPluginsPath() throws Exception {
        Plugins cmd = new Plugins();
        cmd.execute((CommandRunner)new ShellCommandRunner(true));
        Set plugins = new XMLPluginParser().parse(cmd.getStandardOutput());
        Assert.assertTrue((boolean)cmd.getStandardOutput().contains("xmloutput"));
        for (IPlugin plugin : plugins) {
            if (!plugin.getName().equals("xmloutput")) continue;
            return;
        }
        Assert.fail((String)"xmloutput plugin not found");
    }
}

