/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.client.commandline.parser;

import java.io.IOException;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.vcs.bazaar.client.BazaarItemKind;
import org.vcs.bazaar.client.BazaarStatusKind;
import org.vcs.bazaar.client.IBazaarItemInfo;
import org.vcs.bazaar.client.commandline.parser.XMLLsParser;
import org.vcs.bazaar.client.core.BazaarClientException;
import org.vcs.bazaar.client.testUtils.ParserTest;

public class XMLLsParserTest
extends ParserTest {
    @Test
    public void testparse() throws BazaarClientException, IOException {
        List items = XMLLsParser.parse((String)XMLLsParserTest.getContentsFrom("org/vcs/bazaar/client/commandline/parser/ls.xml"));
        Assert.assertNotNull((Object)items);
        Assert.assertFalse((items.size() == 0 ? 1 : 0) != 0);
        Assert.assertEquals((String)"Number of items diffier", (long)45L, (long)items.size());
        int fileCounter = 0;
        int dirCounter = 0;
        int symlinkCounter = 0;
        for (IBazaarItemInfo item : items) {
            fileCounter += BazaarItemKind.FILE.equals((Object)item.getKind()) ? 1 : 0;
            dirCounter += BazaarItemKind.DIRECTORY.equals((Object)item.getKind()) ? 1 : 0;
            symlinkCounter += BazaarItemKind.SYMLINK.equals((Object)item.getKind()) ? 1 : 0;
        }
        Assert.assertEquals((String)"Number of files diffier", (long)44L, (long)fileCounter);
        Assert.assertEquals((String)"Number of directories diffier", (long)1L, (long)dirCounter);
        Assert.assertEquals((String)"Number of synlinks diffier", (long)0L, (long)symlinkCounter);
        int versionedCounter = 0;
        int ignoredCounter = 0;
        int unknownCounter = 0;
        for (IBazaarItemInfo item : items) {
            versionedCounter += BazaarStatusKind.VERSIONED.equals((Object)item.getStatusKind()) ? 1 : 0;
            ignoredCounter += BazaarStatusKind.IGNORED.equals((Object)item.getStatusKind()) ? 1 : 0;
            unknownCounter += BazaarStatusKind.UNKNOWN.equals((Object)item.getStatusKind()) ? 1 : 0;
        }
        Assert.assertEquals((String)"Number of versioned items diffier", (long)21L, (long)versionedCounter);
        Assert.assertEquals((String)"Number of ignored items diffier", (long)19L, (long)ignoredCounter);
        Assert.assertEquals((String)"Number of unknown items diffier", (long)5L, (long)unknownCounter);
    }
}

