/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.client.examples;

import java.io.File;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.vcs.bazaar.client.BazaarClientFactory;
import org.vcs.bazaar.client.BazaarClientPreferences;
import org.vcs.bazaar.client.BazaarPreference;
import org.vcs.bazaar.client.IBazaarClient;
import org.vcs.bazaar.client.IBazaarNotifyListener;
import org.vcs.bazaar.client.commandline.CommandLineClientFactory;
import org.vcs.bazaar.client.commandline.commands.options.Option;
import org.vcs.bazaar.client.core.BazaarClientException;
import org.vcs.bazaar.client.core.BranchLocation;

public class SimpleUsageExample {
    private static final Log LOG = LogFactory.getLog(SimpleUsageExample.class);

    public static void main(String[] args) {
        BazaarClientPreferences.getInstance().set(BazaarPreference.EXECUTABLE, "/usr/bin/bzr");
        try {
            CommandLineClientFactory.setup((boolean)false);
            BazaarClientFactory.setPreferredClientType((String)"CommandLine");
            IBazaarClient client = BazaarClientFactory.createClient((String)BazaarClientFactory.getPreferredClientType());
            client.addNotifyListener((IBazaarNotifyListener)new StandardOutputListener());
            client.branch(new BranchLocation(URI.create("http://freeshells.ch/~guillo/code/bzr-xmloutput/0.17")), new File("/tmp/client_test_remote"), null, new Option[0]);
        }
        catch (BazaarClientException e) {
            LOG.fatal((Object)e.getMessage(), (Throwable)e);
        }
    }

    public static class StandardOutputListener
    implements IBazaarNotifyListener {
        public void logCommandLine(String commandLine) {
            System.out.println(commandLine);
        }

        public void logCommandOutput(String message) {
            System.out.println(message);
        }

        public void logCompleted(String message) {
            System.out.println(message);
        }

        public void logError(String message) {
            System.out.println(message);
        }

        public void logMessage(String message) {
            System.out.println(message);
        }

        public void logRevision(long revision, String path) {
            System.out.println(path + revision);
        }

        public void onNotify(File file) {
            System.out.println(file.getAbsolutePath());
        }

        public void setCommand(int command) {
            System.out.println(command);
        }

        public void logProgress(Thread callingThread, String progress) {
            System.out.println(progress);
        }
    }
}

