/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.client.testUtils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import junit.framework.Assert;
import org.vcs.bazaar.client.BazaarRevision;
import org.vcs.bazaar.client.BazaarStatusKind;
import org.vcs.bazaar.client.IBazaarStatus;
import org.vcs.bazaar.client.testUtils.ExpectedStructure;

public class ExpectedWorkingTree
implements ExpectedStructure {
    protected Map<String, Item> items = new HashMap<String, Item>();

    public void materialize(File root) throws IOException {
        for (Item item : this.items.values()) {
            File dir;
            if (item.myContent != null || (dir = new File(root, item.myPath)).exists()) continue;
            dir.mkdirs();
        }
        for (Item item : this.items.values()) {
            if (item.myContent == null) continue;
            File file = new File(root, item.myPath);
            PrintWriter pw = new PrintWriter(new FileOutputStream(file));
            pw.print(item.myContent);
            pw.close();
        }
    }

    public void addItem(String path, String content) {
        new Item(path, content);
    }

    public Item getItem(String path) {
        return this.items.get(path);
    }

    public int size() {
        return this.items.size();
    }

    public void removeItem(String path) {
        this.items.remove(path);
    }

    public void setItemStatus(String path, BazaarStatusKind kind) {
        if (kind.getCategory() == BazaarStatusKind.Category.CONTENT) {
            this.items.get((Object)path).contentStatus = kind;
        }
        if (kind.getCategory() == BazaarStatusKind.Category.VERSIONED) {
            this.items.get((Object)path).versionStatus = kind;
        }
        if (kind.getCategory() == BazaarStatusKind.Category.EXECUTABLE) {
            this.items.get((Object)path).executeStatus = kind;
        }
    }

    public void setItemRevision(String path, BazaarRevision revision) {
        this.items.get((Object)path).baseRevision = revision;
    }

    public String getItemContent(String path) {
        return this.items.get((Object)path).myContent;
    }

    public void setItemContent(String path, String content) {
        Assert.assertNotNull((String)"cannot unset content", (Object)content);
        Item i = this.items.get(path);
        Assert.assertNotNull((String)"cannot set content on directory", (Object)i.myContent);
        i.myContent = content;
    }

    public void setItemsRevision(BazaarRevision rev) {
        for (Item item : this.items.values()) {
            item.baseRevision = rev;
        }
    }

    public void check(IBazaarStatus[] tested, String workingTreePath) throws Exception {
        if (tested == null || tested.length == 0) {
            return;
        }
        for (IBazaarStatus status : tested) {
            int c;
            String path = status.getPath();
            Item item = this.items.get(path);
            Assert.assertNotNull((String)("status not found for " + path), (Object)item);
            Assert.assertEquals((String)("mismatch in status for " + path), (String)ExpectedWorkingTree.getShortStatus(item.versionStatus, item.contentStatus, item.executeStatus), (String)status.getShortStatus());
            if (item.myContent == null || item.contentStatus == null || item.contentStatus.equals((Object)BazaarStatusKind.DELETED)) continue;
            File input = new File(workingTreePath, item.myPath);
            BufferedReader rd = new BufferedReader(new FileReader(input));
            StringBuilder builder = new StringBuilder();
            while ((c = rd.read()) != -1) {
                builder.append((char)c);
            }
            rd.close();
            String expected = item.myContent;
            String actual = builder.toString();
            Assert.assertEquals((String)("content mismatch for " + path), (String)expected, (String)actual);
        }
    }

    public ExpectedWorkingTree copy() {
        ExpectedWorkingTree newWt = new ExpectedWorkingTree();
        Iterator<Item> it = this.items.values().iterator();
        while (it.hasNext()) {
            it.next().copy(newWt);
        }
        return newWt;
    }

    private static String getShortStatus(BazaarStatusKind versioned, BazaarStatusKind content, BazaarStatusKind execute) {
        StringBuilder sb = new StringBuilder();
        if (versioned != null) {
            sb.append(versioned.toChar());
        }
        if (content != null) {
            sb.append(content.toChar());
        }
        if (execute != null) {
            sb.append(execute.toChar());
        }
        return sb.toString().trim();
    }

    public class Item {
        String myContent;
        String myPath;
        BazaarStatusKind contentStatus = BazaarStatusKind.NONE;
        BazaarStatusKind versionStatus = BazaarStatusKind.NONE;
        BazaarStatusKind executeStatus = BazaarStatusKind.NONE;
        BazaarRevision baseRevision = BazaarRevision.INVALID;

        protected Item(String path, String content) {
            this.myPath = path;
            this.myContent = content;
            ExpectedWorkingTree.this.items.put(path, this);
        }

        private Item(Item existing, ExpectedWorkingTree wt) {
            this.contentStatus = existing.contentStatus;
            this.versionStatus = existing.versionStatus;
            this.executeStatus = existing.executeStatus;
            this.myPath = existing.myPath;
            this.myContent = existing.myContent;
            wt.items.put(this.myPath, this);
        }

        protected Item copy(ExpectedWorkingTree owner) {
            return new Item(this, owner);
        }

        public String getPath() {
            return this.myPath;
        }

        public String getContent() {
            return this.myContent;
        }
    }
}

