/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.client.utils;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URL;
import org.junit.Assert;
import org.junit.Test;
import org.vcs.bazaar.client.utils.BazaarUtilities;
import org.vcs.bazaar.client.utils.StringUtil;

public class StringUtilTest {
    public static final String[] REMOTE_SCHEMES = new String[]{"http", "sftp", "ftp", "rsync", "https", "bzr+ssh", "bzr+http", "bzr+https", "https+urllib"};

    @Test
    public final void testGetAbsoluteURIString() throws Exception {
        URI expected = URI.create("/Users/username/test_dir");
        String uriStr = "/Users/username/test_dir";
        URI actual = StringUtil.getAbsoluteURI((String)uriStr);
        Assert.assertEquals((Object)expected.toString(), (Object)actual.toString());
        expected = URI.create("file:///Users/username/test_dir");
        uriStr = "file:/Users/username/test_dir";
        actual = StringUtil.getAbsoluteURI((String)uriStr);
        Assert.assertEquals((Object)expected.toString(), (Object)actual.toString());
        uriStr = "file://Users/username/test_dir";
        actual = StringUtil.getAbsoluteURI((String)uriStr);
        Assert.assertEquals((Object)expected.toString(), (Object)actual.toString());
        uriStr = "file:///Users/username/test_dir";
        actual = StringUtil.getAbsoluteURI((String)uriStr);
        Assert.assertEquals((Object)expected.toString(), (Object)actual.toString());
        expected = URI.create("/Users/user%20name/test_dir");
        uriStr = "/Users/user name/test_dir";
        actual = StringUtil.getAbsoluteURI((String)uriStr);
        Assert.assertEquals((Object)expected, (Object)actual);
        if (BazaarUtilities.isWindows()) {
            expected = new URL("file:///c:/Users/user%20name/test_dir").toURI();
            uriStr = "C:\\Users\\user name\\test_dir";
            actual = StringUtil.getAbsoluteURI((String)uriStr);
            Assert.assertEquals((Object)expected, (Object)actual);
        }
    }

    @Test
    public final void testGetAbsoluteURIFile() {
        String path = "/Users/username/test_dir";
        if (BazaarUtilities.isWindows()) {
            path = "/c:/Users/username/test_dir";
        }
        File file = new File(path);
        URI expected = URI.create("file://" + path);
        URI actual = StringUtil.getAbsoluteURI((File)file);
        Assert.assertEquals((Object)expected.toString(), (Object)actual.toString());
        file = new File(URI.create("file:" + path));
        actual = StringUtil.getAbsoluteURI((File)file);
        Assert.assertEquals((Object)expected.toString(), (Object)actual.toString());
    }

    @Test
    public final void testGetAbsoluteURIURI() {
        URI expected = URI.create("file:///Users/username/test_dir");
        URI actual = StringUtil.getAbsoluteURI((URI)URI.create("file:///Users/username/test_dir"));
        Assert.assertEquals((Object)expected.toString(), (Object)actual.toString());
        actual = StringUtil.getAbsoluteURI((URI)URI.create("file://Users/username/test_dir"));
        Assert.assertEquals((Object)expected.toString(), (Object)actual.toString());
        actual = StringUtil.getAbsoluteURI((URI)URI.create("file:/Users/username/test_dir"));
        Assert.assertEquals((Object)expected.toString(), (Object)actual.toString());
    }

    @Test
    public final void testGetAbsoluteURISchemas() {
        String[] schemes;
        for (String scheme : schemes = REMOTE_SCHEMES) {
            URI expected = URI.create(scheme + "://Users/username/test_dir");
            URI actual = StringUtil.getAbsoluteURI((URI)URI.create(scheme + "://Users/username/test_dir"));
            Assert.assertEquals((Object)expected.toString(), (Object)actual.toString());
        }
        URI expected = URI.create("file:///Users/username/test_dir");
        URI actual = StringUtil.getAbsoluteURI((URI)URI.create("file:///Users/username/test_dir"));
        Assert.assertEquals((Object)expected.toString(), (Object)actual.toString());
    }

    @Test
    public final void testGetAbsoluteURISingleChar() {
        URI expected = URI.create("b");
        URI actual = StringUtil.getAbsoluteURI((String)"b");
        Assert.assertEquals((Object)expected.toString(), (Object)actual.toString());
        expected = URI.create("file:///b");
        actual = StringUtil.getAbsoluteURI((URI)URI.create("file:///b"));
        Assert.assertEquals((Object)expected.toString(), (Object)actual.toString());
        actual = StringUtil.getAbsoluteURI((URI)URI.create("file://b"));
        Assert.assertEquals((Object)expected.toString(), (Object)actual.toString());
        actual = StringUtil.getAbsoluteURI((URI)URI.create("file:/b"));
        Assert.assertEquals((Object)expected.toString(), (Object)actual.toString());
        if (BazaarUtilities.isWindows()) {
            expected = URI.create("file:///c:/b");
            actual = StringUtil.getAbsoluteURI((URI)URI.create("file:/c:/b"));
            Assert.assertEquals((Object)expected.toString(), (Object)actual.toString());
            actual = StringUtil.getAbsoluteURI((String)"file:/c:/b");
            Assert.assertEquals((Object)expected.toString(), (Object)actual.toString());
        }
    }

    @Test
    public final void testUrlEncodeWin() throws UnsupportedEncodingException {
        String raw = "file:///c:/Ma\u00e7\u00e3/does/not/exist";
        String url = "file:///c:/Ma%C3%A7%C3%A3/does/not/exist";
        Assert.assertEquals((Object)url, (Object)StringUtil.urlEncode((String)raw));
        raw = "file:///c:/non/ascii/terminated/ma\u00e7\u00e3";
        url = "file:///c:/non/ascii/terminated/ma%C3%A7%C3%A3";
        Assert.assertEquals((Object)url, (Object)StringUtil.urlEncode((String)raw));
    }

    @Test
    public final void testUrlEncodeUnix() throws UnsupportedEncodingException {
        String raw = "file:///home/Ma\u00e7\u00e3/does/not/exist";
        String url = "file:///home/Ma%C3%A7%C3%A3/does/not/exist";
        Assert.assertEquals((Object)url, (Object)StringUtil.urlEncode((String)raw));
        raw = "/home/Ma\u00e7\u00e3/does/not/exist";
        url = "/home/Ma%C3%A7%C3%A3/does/not/exist";
        Assert.assertEquals((Object)url, (Object)StringUtil.urlEncode((String)raw));
        raw = "lp:~Ma\u00e7\u00e3/does/not/exist";
        url = "lp:~Ma%C3%A7%C3%A3/does/not/exist";
        Assert.assertEquals((Object)url, (Object)StringUtil.urlEncode((String)raw));
        for (String scheme : REMOTE_SCHEMES) {
            raw = scheme + "://Ma\u00e7\u00e3/does/not/exist";
            url = scheme + "://Ma%C3%A7%C3%A3/does/not/exist";
            Assert.assertEquals((Object)url, (Object)StringUtil.urlEncode((String)raw));
        }
    }

    @Test
    public final void testUrlEncodeRemote() throws UnsupportedEncodingException {
        for (String scheme : REMOTE_SCHEMES) {
            String raw = scheme + "://Ma\u00e7\u00e3/does/not/exist";
            String url = scheme + "://Ma%C3%A7%C3%A3/does/not/exist";
            Assert.assertEquals((Object)url, (Object)StringUtil.urlEncode((String)raw));
        }
    }
}

