/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.client;

import java.util.HashMap;
import java.util.Map;
import org.vcs.bazaar.client.IBazaarClient;
import org.vcs.bazaar.client.commandline.CommandLineClientFactory;
import org.vcs.bazaar.client.core.BazaarClientException;
import org.vcs.bazaar.client.utils.BazaarUtilities;
import org.vcs.bazaar.client.xmlrpc.XmlRpcClientFactory;

public abstract class BazaarClientFactory {
    private static Map<String, BazaarClientFactory> factories = new HashMap<String, BazaarClientFactory>();
    private static BazaarClientFactory bestFactory;

    public static IBazaarClient createClient(String clientType) {
        if (factories.containsKey(clientType)) {
            BazaarClientFactory factory = factories.get(clientType);
            return factory != null ? factory.createClientImpl() : null;
        }
        return null;
    }

    public static final boolean isClientTypeAvailable(String clientType) {
        return factories.containsKey(clientType);
    }

    public static final void setPreferredClientType(String clientType) {
        bestFactory = factories.get(clientType);
    }

    public static final String getPreferredClientType() throws BazaarClientException {
        if (bestFactory != null) {
            return bestFactory.getClientType();
        }
        throw new BazaarClientException("No client factory found");
    }

    protected static void registerAdapterFactory(BazaarClientFactory newFactory) {
        if (newFactory != null) {
            factories.put(newFactory.getClientType(), newFactory);
        }
        if (bestFactory == null) {
            bestFactory = newFactory;
        }
    }

    protected abstract IBazaarClient createClientImpl();

    protected abstract String getClientType();

    public static String[] getClientTypes() {
        return factories.keySet().toArray(new String[0]);
    }

    public static String setupBestAvailableBackend(boolean force) throws BazaarClientException {
        BazaarUtilities.checkExecutable();
        String preferredClientType = null;
        try {
            CommandLineClientFactory.setup(force);
            preferredClientType = "CommandLine";
        }
        catch (BazaarClientException bce) {
            bestFactory = null;
            throw bce;
        }
        try {
            XmlRpcClientFactory.setup(force);
            preferredClientType = "XmlRpcClient";
        }
        catch (BazaarClientException bazaarClientException) {
            // empty catch block
        }
        BazaarClientFactory.setPreferredClientType(preferredClientType);
        return BazaarClientFactory.getPreferredClientType();
    }

    public static String setupBestAvailableBackend() throws BazaarClientException {
        return BazaarClientFactory.setupBestAvailableBackend(false);
    }
}

