/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.client.commandline;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.vcs.bazaar.client.BazaarClient;
import org.vcs.bazaar.client.BazaarNotificationHandler;
import org.vcs.bazaar.client.BazaarRevision;
import org.vcs.bazaar.client.BazaarRevisionRange;
import org.vcs.bazaar.client.BazaarTreeStatus;
import org.vcs.bazaar.client.BazaarVersion;
import org.vcs.bazaar.client.BazaarVersionInfo;
import org.vcs.bazaar.client.IBazaarAnnotation;
import org.vcs.bazaar.client.IBazaarConflict;
import org.vcs.bazaar.client.IBazaarInfo;
import org.vcs.bazaar.client.IBazaarItemInfo;
import org.vcs.bazaar.client.IBazaarLogMessage;
import org.vcs.bazaar.client.IBazaarNotifyListener;
import org.vcs.bazaar.client.IBazaarProgressListener;
import org.vcs.bazaar.client.IBazaarRevisionSpec;
import org.vcs.bazaar.client.IBazaarShelf;
import org.vcs.bazaar.client.IBazaarTag;
import org.vcs.bazaar.client.IBzrLogMessageHandler;
import org.vcs.bazaar.client.IPlugin;
import org.vcs.bazaar.client.commandline.CommandLineAnnotation;
import org.vcs.bazaar.client.commandline.CommandLineNotificationHandler;
import org.vcs.bazaar.client.commandline.commands.Add;
import org.vcs.bazaar.client.commandline.commands.Annotate;
import org.vcs.bazaar.client.commandline.commands.Bind;
import org.vcs.bazaar.client.commandline.commands.Branch;
import org.vcs.bazaar.client.commandline.commands.Cat;
import org.vcs.bazaar.client.commandline.commands.CheckOut;
import org.vcs.bazaar.client.commandline.commands.Commit;
import org.vcs.bazaar.client.commandline.commands.Conflicts;
import org.vcs.bazaar.client.commandline.commands.Diff;
import org.vcs.bazaar.client.commandline.commands.FindMergeBase;
import org.vcs.bazaar.client.commandline.commands.Ignore;
import org.vcs.bazaar.client.commandline.commands.Info;
import org.vcs.bazaar.client.commandline.commands.Init;
import org.vcs.bazaar.client.commandline.commands.Log;
import org.vcs.bazaar.client.commandline.commands.Ls;
import org.vcs.bazaar.client.commandline.commands.Merge;
import org.vcs.bazaar.client.commandline.commands.Missing;
import org.vcs.bazaar.client.commandline.commands.Move;
import org.vcs.bazaar.client.commandline.commands.Nick;
import org.vcs.bazaar.client.commandline.commands.Plugins;
import org.vcs.bazaar.client.commandline.commands.Pull;
import org.vcs.bazaar.client.commandline.commands.Push;
import org.vcs.bazaar.client.commandline.commands.Rebase;
import org.vcs.bazaar.client.commandline.commands.RebaseAbort;
import org.vcs.bazaar.client.commandline.commands.RebaseContinue;
import org.vcs.bazaar.client.commandline.commands.RebaseToDo;
import org.vcs.bazaar.client.commandline.commands.Remove;
import org.vcs.bazaar.client.commandline.commands.Resolve;
import org.vcs.bazaar.client.commandline.commands.Revert;
import org.vcs.bazaar.client.commandline.commands.RevisionInfo;
import org.vcs.bazaar.client.commandline.commands.Revno;
import org.vcs.bazaar.client.commandline.commands.Send;
import org.vcs.bazaar.client.commandline.commands.Shelve;
import org.vcs.bazaar.client.commandline.commands.ShelveList;
import org.vcs.bazaar.client.commandline.commands.Status;
import org.vcs.bazaar.client.commandline.commands.Switch;
import org.vcs.bazaar.client.commandline.commands.Tag;
import org.vcs.bazaar.client.commandline.commands.Tags;
import org.vcs.bazaar.client.commandline.commands.UnBind;
import org.vcs.bazaar.client.commandline.commands.UnCommit;
import org.vcs.bazaar.client.commandline.commands.UnShelve;
import org.vcs.bazaar.client.commandline.commands.Unknowns;
import org.vcs.bazaar.client.commandline.commands.Update;
import org.vcs.bazaar.client.commandline.commands.Version;
import org.vcs.bazaar.client.commandline.commands.VersionInfo;
import org.vcs.bazaar.client.commandline.commands.options.KeywordOption;
import org.vcs.bazaar.client.commandline.commands.options.Option;
import org.vcs.bazaar.client.commandline.internal.Command;
import org.vcs.bazaar.client.commandline.internal.CommandRunner;
import org.vcs.bazaar.client.commandline.internal.ShellCommandRunner;
import org.vcs.bazaar.client.commandline.parser.XMLConflictsParser;
import org.vcs.bazaar.client.commandline.parser.XMLInfoParser;
import org.vcs.bazaar.client.commandline.parser.XMLLogParser;
import org.vcs.bazaar.client.commandline.parser.XMLLsParser;
import org.vcs.bazaar.client.commandline.parser.XMLMissingParser;
import org.vcs.bazaar.client.commandline.parser.XMLPluginParser;
import org.vcs.bazaar.client.commandline.parser.XMLShelveListParser;
import org.vcs.bazaar.client.commandline.parser.XMLStatusParser;
import org.vcs.bazaar.client.commandline.parser.XMLTagsParser;
import org.vcs.bazaar.client.commandline.parser.XMLVersionParser;
import org.vcs.bazaar.client.commandline.syntax.ILogOptions;
import org.vcs.bazaar.client.commandline.syntax.ILsOptions;
import org.vcs.bazaar.client.commandline.syntax.IVersionInfoOptions;
import org.vcs.bazaar.client.core.BazaarClientException;
import org.vcs.bazaar.client.core.BranchLocation;
import org.vcs.bazaar.client.utils.BazaarUtilities;
import org.vcs.bazaar.client.xmlrpc.XmlRpcCommandException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandLineClient
extends BazaarClient {
    protected final CommandLineNotificationHandler notificationHandler;
    private static boolean alreadyAskedForAvailability = false;
    private static boolean available;
    private static final int[] XMLOUTPUT_VERSION;
    private static final int POINT = 2;
    private static final int MINOR = 1;
    private static final int MAJOR = 0;

    public CommandLineClient(CommandLineNotificationHandler notificationHandler) {
        this.notificationHandler = notificationHandler;
    }

    @Override
    public void add(File[] files, Option ... options) throws BazaarClientException {
        Add cmd = new Add(this.workDir, files);
        this.setOptions(cmd, options);
        this.run(cmd);
        this.notificationHandler.logCompleted(cmd.getStandardOutput());
    }

    @Override
    public IBazaarAnnotation annotate(File file, Option ... options) throws BazaarClientException {
        Annotate cmd = new Annotate(this.workDir, file);
        this.setOptions(cmd, options);
        this.run(cmd);
        return CommandLineAnnotation.getAnnotationFromXml(cmd.getStandardOutput());
    }

    @Override
    public void branch(BranchLocation fromLocation, File toLocation, IBazaarRevisionSpec revision, Option ... options) throws BazaarClientException {
        this.branch(fromLocation, toLocation, revision, (IBazaarProgressListener)null, options);
    }

    @Override
    public InputStream cat(File file, IBazaarRevisionSpec revision, String charsetName, Option ... options) throws BazaarClientException {
        Cat cmd = new Cat(this.workDir, file);
        return this.cat(cmd, revision, charsetName, options);
    }

    private InputStream cat(Cat cmd, IBazaarRevisionSpec revision, String charsetName, Option ... options) throws BazaarClientException {
        if (revision == null) {
            cmd.setOption(Cat.REVISION.with(BazaarRevision.getRevision(BazaarRevision.Prefix.LAST, "").toString()));
        } else {
            cmd.setOption(Cat.REVISION.with(revision.toString()));
        }
        this.setOptions(cmd, options);
        this.run(cmd);
        if (charsetName != null) {
            try {
                return new ByteArrayInputStream(cmd.getStandardOutput(charsetName).getBytes(charsetName));
            }
            catch (UnsupportedEncodingException e) {
                return new ByteArrayInputStream(cmd.getStandardOutput().getBytes());
            }
        }
        return new ByteArrayInputStream(cmd.getStandardOutput().getBytes());
    }

    @Override
    public void checkout(BranchLocation fromLocation, File toLocation, Option ... options) throws BazaarClientException {
        this.checkout(fromLocation, toLocation, (IBazaarProgressListener)null, options);
    }

    @Override
    public void commit(File[] files, String message, Option ... options) throws BazaarClientException {
        Commit cmd = new Commit(this.workDir, files, message);
        this.setOptions(cmd, options);
        this.run(cmd);
        this.notificationHandler.logCompleted(cmd.getStandardOutput());
    }

    @Override
    public String diff(File[] files, IBazaarRevisionSpec range, Option ... options) throws BazaarClientException {
        Diff cmd = new Diff(this.workDir, files);
        if (range != null) {
            cmd.setOption(Diff.REVISION.with(range.toString()));
        }
        this.setOptions(cmd, options);
        this.run(cmd);
        return cmd.getStandardOutput();
    }

    @Override
    public void init(File location, Option ... options) throws BazaarClientException {
        Init cmd = new Init(location);
        this.setOptions(cmd, options);
        this.run(cmd);
    }

    @Override
    public List<IBazaarLogMessage> log(File location, Option ... options) throws BazaarClientException {
        Log cmd = new Log(this.workDir, location);
        return this.log(cmd, options);
    }

    @Override
    public List<IBazaarLogMessage> log(URI location, Option ... options) throws BazaarClientException {
        Log cmd = new Log(this.workDir, location);
        return this.log(cmd, options);
    }

    @Override
    public List<IBazaarLogMessage> log(BranchLocation location, Option ... options) throws BazaarClientException {
        Log cmd = new Log(this.workDir, location);
        return this.log(cmd, options);
    }

    @Override
    public void log(BranchLocation location, IBzrLogMessageHandler logHandler, Option ... options) throws BazaarClientException {
        this.log(location, logHandler, false, options);
    }

    @Override
    public void logAsync(BranchLocation location, IBzrLogMessageHandler logHandler, Option ... options) throws BazaarClientException {
        this.log(location, logHandler, true, options);
    }

    protected void log(BranchLocation location, final IBzrLogMessageHandler logHandler, boolean async, Option ... options) throws BazaarClientException {
        int verboseIdx;
        int limit = 1;
        int fetchSize = 1000;
        options = ILogOptions.REVISION.removeFrom(options);
        Arrays.sort(options);
        int limitIdx = Arrays.binarySearch(options, ILogOptions.LIMIT);
        if (limitIdx >= 0) {
            String limitStr = ((KeywordOption)options[limitIdx]).getArgument();
            if (limitStr != null && !"".equals(limitStr)) {
                limit = Integer.valueOf(limitStr);
            }
            options = ILogOptions.LIMIT.removeFrom(options);
        }
        if ((verboseIdx = Arrays.binarySearch(options, ILogOptions.VERBOSE)) >= 0) {
            fetchSize = 100;
        }
        int iterations = limit / fetchSize;
        ExecutorService executor = Executors.newFixedThreadPool(1);
        ArrayList futures = new ArrayList(iterations);
        int startRev = fetchSize;
        int endRev = 1;
        BazaarRevision lastRevno = this.revno(location);
        int endRevMaxValue = Integer.valueOf(lastRevno.getValue());
        for (int i = 0; i < iterations && (startRev = fetchSize * (i + 1)) <= endRevMaxValue; ++i) {
            Log log = new Log(this.workDir, location);
            for (Option option : options) {
                log.setOption(option);
            }
            BazaarRevision start = BazaarRevision.getRevision(BazaarRevision.Prefix.LAST, String.valueOf(startRev));
            BazaarRevision end = BazaarRevision.getRevision(BazaarRevision.Prefix.LAST, String.valueOf(endRev));
            log.setOption(ILogOptions.REVISION.with(BazaarRevisionRange.getRange(start, end).toString()));
            this.run(log);
            final String xml = log.getStandardOutput();
            Runnable logHandlerRunnable = new Runnable(){

                public void run() {
                    try {
                        logHandler.handle(XMLLogParser.parse(xml));
                    }
                    catch (BazaarClientException e) {
                        CommandLineClient.this.notificationHandler.logException(e);
                    }
                }
            };
            futures.add(executor.submit(logHandlerRunnable));
            endRev = startRev + 1;
            if (endRev <= endRevMaxValue) continue;
            endRev = endRevMaxValue;
        }
        if (!async) {
            for (Future future : futures) {
                try {
                    future.get();
                }
                catch (InterruptedException e) {
                    executor.shutdownNow();
                    throw BazaarClientException.wrapException(e);
                }
                catch (ExecutionException e) {
                    executor.shutdownNow();
                    throw BazaarClientException.wrapException(e);
                }
            }
        }
        executor.shutdown();
    }

    private List<IBazaarLogMessage> log(Command cmd, Option ... options) throws BazaarClientException {
        this.setOptions(cmd, options);
        this.run(cmd);
        return XMLLogParser.parse(cmd.getStandardOutput());
    }

    @Override
    public void move(File[] orig, File dest, Option ... options) throws BazaarClientException {
        Move cmd = new Move(this.workDir, orig, dest);
        this.setOptions(cmd, options);
        this.run(cmd);
    }

    @Override
    public String nick(String newNick) throws BazaarClientException {
        Nick cmd = new Nick(this.workDir, newNick);
        this.run(cmd);
        String nick = cmd.getStandardOutput();
        return nick == null ? "" : nick.replaceAll("\n", "").replaceAll("\r", "");
    }

    @Override
    public Set<IPlugin> plugins() throws BazaarClientException {
        Plugins cmd = new Plugins();
        this.run(cmd);
        return new XMLPluginParser().parse(cmd.getStandardOutput());
    }

    @Override
    public void pull(BranchLocation location, Option ... options) throws BazaarClientException {
        Pull cmd = new Pull(this.workDir, location);
        this.setOptions(cmd, options);
        this.run(cmd);
        this.notificationHandler.logCompleted(cmd.getStandardOutput());
    }

    @Override
    public void push(BranchLocation location, Option ... options) throws BazaarClientException {
        Push cmd = new Push(this.workDir, location);
        this.setOptions(cmd, options);
        this.run(cmd);
        this.notificationHandler.logCompleted(cmd.getStandardOutput());
    }

    @Override
    public void remove(File[] files, Option ... options) throws BazaarClientException {
        Remove cmd = new Remove(this.workDir, files);
        this.setOptions(cmd, options);
        this.run(cmd);
    }

    @Override
    public void revert(File[] files, Option ... options) throws BazaarClientException {
        Revert cmd = new Revert(this.workDir, files);
        this.setOptions(cmd, options);
        this.run(cmd);
    }

    @Override
    public BazaarRevision revno(BranchLocation location) throws BazaarClientException {
        Revno cmd = location != null ? new Revno(this.workDir, location) : new Revno(this.workDir, new BranchLocation(new File(".")));
        this.run(cmd);
        return BazaarRevision.getRevision(BazaarRevision.Prefix.REVNO, cmd.getStandardOutput());
    }

    @Override
    public BazaarRevision revisionInfo(File location, IBazaarRevisionSpec revision) throws BazaarClientException {
        RevisionInfo cmd = location != null ? new RevisionInfo(location) : new RevisionInfo(this.workDir);
        if (revision != null) {
            cmd.setOption(RevisionInfo.REVISION.with(revision.toString()));
        }
        this.run(cmd);
        String revString = cmd.getStandardOutput();
        revString = revString.substring(revString.lastIndexOf(32) + 1).trim();
        return BazaarRevision.getRevision(BazaarRevision.Prefix.REVID, revString);
    }

    @Override
    public BazaarTreeStatus status(File[] files, Option ... options) throws BazaarClientException {
        if (files == null) {
            files = new File[]{new File(".")};
        }
        Status cmd = new Status(this.workDir, files);
        this.setOptions(cmd, options);
        this.run(cmd);
        BazaarTreeStatus status = null;
        if (cmd.getStandardOutput() != null) {
            XMLStatusParser parser = new XMLStatusParser();
            parser.parse(cmd.getStandardOutput());
            status = new BazaarTreeStatus(parser.getStatusSet(), parser.getPendingMerges());
        } else {
            status = new BazaarTreeStatus();
        }
        return status;
    }

    @Override
    public void unCommit(File location, Option ... options) throws BazaarClientException {
        UnCommit cmd = new UnCommit(this.workDir, location);
        cmd.setOption(UnCommit.FORCE);
        this.setOptions(cmd, options);
        this.run(cmd);
        this.notificationHandler.logCompleted(cmd.getStandardOutput());
    }

    @Override
    public void ignore(File file, String pattern) throws BazaarClientException {
        Ignore cmd = new Ignore(file, pattern);
        this.run(cmd);
    }

    @Override
    public Map<String, String> ignored(File file) throws BazaarClientException {
        IBazaarItemInfo[] ignored = this.ls(file, null, Ls.IGNORED);
        HashMap<String, String> result = new HashMap<String, String>(ignored.length);
        for (IBazaarItemInfo item : ignored) {
            result.put(item.getPath(), item.getPattern());
        }
        return result;
    }

    @Override
    public String[] unknowns(File workDir) throws BazaarClientException {
        Unknowns cmd = new Unknowns(workDir, null);
        this.run(cmd);
        return cmd.getStandardOutputSplit();
    }

    @Override
    public IBazaarItemInfo[] ls(File workDir, IBazaarRevisionSpec revision, Option ... options) throws BazaarClientException {
        Ls cmd = new Ls(workDir);
        return this.ls(cmd, revision, options);
    }

    @Override
    public IBazaarItemInfo[] ls(BranchLocation location, IBazaarRevisionSpec revision, Option ... options) throws BazaarClientException {
        Ls cmd = new Ls(this.workDir, location);
        return this.ls(cmd, revision, options);
    }

    @Override
    public IBazaarItemInfo[] ls(URI location, IBazaarRevisionSpec revision, Option ... options) throws BazaarClientException {
        Ls cmd = new Ls(this.workDir, location);
        return this.ls(cmd, revision, options);
    }

    private IBazaarItemInfo[] ls(Ls cmd, IBazaarRevisionSpec revision, Option ... options) throws BazaarClientException {
        if (revision != null) {
            cmd.setOption(ILsOptions.REVISION.with(revision.toString()));
        }
        this.setOptions(cmd, options);
        try {
            this.run(cmd);
            return XMLLsParser.parse(cmd.getStandardOutput()).toArray(new IBazaarItemInfo[0]);
        }
        catch (BazaarClientException e) {
            return new IBazaarItemInfo[0];
        }
    }

    @Override
    public String update(File file, Option ... options) throws BazaarClientException {
        Update cmd = new Update(this.workDir, file);
        this.setOptions(cmd, options);
        this.run(cmd);
        return cmd.getStandardError();
    }

    @Override
    public IBazaarInfo info(BranchLocation location, Option ... options) throws BazaarClientException {
        Info cmd = new Info(this.workDir, location);
        this.setOptions(cmd, options);
        this.run(cmd);
        IBazaarInfo info = new XMLInfoParser().parse(cmd.getStandardOutput());
        if (info == null) {
            throw new BazaarClientException("An unexpected error occurred while getting the info of: " + location.toString());
        }
        return info;
    }

    @Override
    public void bind(BranchLocation location, Option ... options) throws BazaarClientException {
        Bind cmd = new Bind(this.workDir, location);
        this.setOptions(cmd, options);
        this.run(cmd);
        this.notificationHandler.logCompleted(cmd.getStandardOutput());
    }

    @Override
    public void unBind(Option ... options) throws BazaarClientException {
        UnBind cmd = new UnBind(this.workDir);
        this.setOptions(cmd, options);
        this.run(cmd);
        this.notificationHandler.logCompleted(cmd.getStandardOutput());
    }

    @Override
    public Map<String, List<IBazaarLogMessage>> missing(File workdir, BranchLocation otherBranch, Option ... options) throws BazaarClientException {
        Missing cmd = new Missing(this.workDir, otherBranch);
        this.setOptions(cmd, options);
        this.run(cmd);
        if (cmd.getStandardOutput() == null || cmd.getStandardOutput().trim().equals("")) {
            return new HashMap<String, List<IBazaarLogMessage>>(0);
        }
        return new XMLMissingParser().parse(cmd.getStandardOutput());
    }

    @Override
    public void switchBranch(BranchLocation location, Option ... options) throws BazaarClientException {
        Switch cmd = new Switch(this.workDir, location);
        this.setOptions(cmd, options);
        this.run(cmd);
        this.notificationHandler.logCompleted(cmd.getStandardOutput());
    }

    @Override
    public void merge(BranchLocation remoteBranch, Option ... options) throws BazaarClientException {
        Merge cmd = new Merge(this.workDir, remoteBranch);
        this.setOptions(cmd, options);
        this.run(cmd);
        this.notificationHandler.logCompleted(cmd.getStandardOutput());
    }

    @Override
    public void resolve(List<File> files, Option ... options) throws BazaarClientException {
        Resolve cmd = new Resolve(this.workDir, files);
        this.setOptions(cmd, options);
        this.run(cmd);
    }

    @Override
    public void send(BranchLocation submitBranch, Option ... options) throws BazaarClientException {
        Send cmd = new Send(this.workDir, submitBranch);
        this.setOptions(cmd, options);
        this.run(cmd);
    }

    @Override
    public BazaarVersionInfo versionInfo(BranchLocation location, Option ... options) throws BazaarClientException {
        VersionInfo cmd = new VersionInfo(this.workDir, location);
        this.setOptions(cmd, options);
        cmd.setOption(IVersionInfoOptions.FORMAT.with("rio"));
        this.run(cmd);
        return BazaarVersionInfo.parse(cmd.getStandardOutput());
    }

    public BazaarVersion version(Option ... options) throws BazaarClientException {
        Version cmd = new Version();
        this.setOptions(cmd, options);
        this.run(cmd);
        return XMLVersionParser.parse(cmd.getStandardOutput());
    }

    @Override
    public void addNotifyListener(IBazaarNotifyListener listener) {
        this.notificationHandler.add(listener);
    }

    @Override
    public BazaarNotificationHandler getNotificationHandler() {
        return this.notificationHandler;
    }

    @Override
    public void removeNotifyListener(IBazaarNotifyListener listener) {
        this.notificationHandler.remove(listener);
    }

    protected void run(Command cmd) throws BazaarClientException {
        this.run(cmd, this.getCommandRunner());
    }

    protected void run(Command cmd, CommandRunner runner) throws BazaarClientException {
        try {
            this.notificationHandler.logCommandLine(this.getClass().getSimpleName() + " " + cmd.getCommandInfo());
            runner.setPasswordCallback(this.userPasswordPrompt);
            cmd.execute(runner);
            String err = cmd.getStandardError();
            if (err != null && err.length() > 0) {
                this.notificationHandler.logError(cmd.getStandardError());
            }
        }
        catch (BazaarClientException e) {
            this.notificationHandler.logError(cmd.getCommandError());
            this.notificationHandler.logException(e);
            throw e;
        }
    }

    @Override
    public BazaarRevision findMergeBase(BranchLocation branch, BranchLocation other) throws BazaarClientException {
        FindMergeBase cmd = new FindMergeBase(branch, other);
        this.run(cmd);
        String output = cmd.getStandardOutput();
        output = output.replace("merge base is revision ", "").trim();
        return BazaarRevision.getRevision(BazaarRevision.Prefix.REVID, output);
    }

    @Override
    protected CommandRunner getCommandRunner() {
        return new ShellCommandRunner(true);
    }

    @Override
    public void tag(String tagName, Option ... options) throws BazaarClientException {
        Tag cmd = new Tag(this.workDir, tagName);
        this.setOptions(cmd, options);
        this.run(cmd);
        this.notificationHandler.logCompleted(cmd.getStandardOutput());
    }

    @Override
    public List<IBazaarTag> tags(Option ... options) throws BazaarClientException {
        Tags cmd = new Tags(this.workDir);
        this.setOptions(cmd, options);
        this.run(cmd);
        return XMLTagsParser.parse(cmd.getStandardOutput());
    }

    @Override
    public void shelve(File[] files, Option ... options) throws BazaarClientException {
        Shelve cmd = new Shelve(this.workDir, files);
        this.setOptions(cmd, options);
        this.run(cmd);
        this.notificationHandler.logCompleted(cmd.getStandardOutput());
    }

    @Override
    public void unShelve(String shelfId, Option ... options) throws BazaarClientException {
        UnShelve cmd = new UnShelve(this.workDir, shelfId);
        this.setOptions(cmd, options);
        this.run(cmd);
        this.notificationHandler.logCompleted(cmd.getStandardOutput());
    }

    @Override
    public List<IBazaarShelf> shelveList(Option ... options) throws BazaarClientException {
        ShelveList cmd = new ShelveList(this.workDir);
        this.setOptions(cmd, options);
        this.run(cmd);
        return XMLShelveListParser.parse(cmd.getStandardOutput());
    }

    @Override
    public List<IBazaarConflict> conflicts(Option ... options) throws BazaarClientException {
        Conflicts cmd = new Conflicts(this.workDir);
        this.setOptions(cmd, options);
        this.run(cmd);
        return XMLConflictsParser.parse(cmd.getStandardOutput());
    }

    @Override
    public InputStream cat(BranchLocation location, IBazaarRevisionSpec revision, String charsetName, Option ... options) throws BazaarClientException {
        Cat cmd = new Cat(this.workDir, location);
        return this.cat(cmd, revision, charsetName, options);
    }

    @Override
    public InputStream cat(URI location, IBazaarRevisionSpec revision, String charsetName, Option ... options) throws BazaarClientException {
        Cat cmd = new Cat(this.workDir, location);
        return this.cat(cmd, revision, charsetName, options);
    }

    @Override
    public void branch(BranchLocation fromLocation, File toLocation, IBazaarRevisionSpec revision, IBazaarProgressListener listener, Option ... options) throws BazaarClientException {
        Branch cmd = new Branch(fromLocation, toLocation);
        cmd.setProgressListener(listener);
        if (revision != null) {
            cmd.setOption(Branch.REVISION.with(revision.toString()));
        }
        this.setOptions(cmd, options);
        this.run(cmd);
        this.notificationHandler.logCompleted(cmd.getStandardOutput());
    }

    @Override
    public void checkout(BranchLocation fromLocation, File toLocation, IBazaarProgressListener listener, Option ... options) throws BazaarClientException {
        CheckOut cmd = new CheckOut(fromLocation, toLocation);
        cmd.setProgressListener(listener);
        this.setOptions(cmd, options);
        this.run(cmd);
        this.notificationHandler.logCompleted(cmd.getStandardOutput());
    }

    @Override
    public void rebase(BranchLocation remoteBranch, Option ... options) throws BazaarClientException {
        Rebase cmd = new Rebase(this.workDir, remoteBranch);
        this.setOptions(cmd, options);
        this.run(cmd);
        this.notificationHandler.logCompleted(cmd.getStandardOutput());
    }

    @Override
    public boolean rebaseToDo(Option ... options) throws BazaarClientException {
        RebaseToDo cmd = new RebaseToDo(this.workDir);
        this.setOptions(cmd, options);
        try {
            this.run(cmd);
        }
        catch (XmlRpcCommandException e) {
            if ("No rebase in progress".equals(e.getMessage())) {
                return false;
            }
            throw e;
        }
        this.notificationHandler.logCompleted(cmd.getStandardOutput());
        return true;
    }

    @Override
    public void rebaseContinue(Option ... options) throws BazaarClientException {
        RebaseContinue cmd = new RebaseContinue(this.workDir);
        this.setOptions(cmd, options);
        this.run(cmd);
        this.notificationHandler.logCompleted(cmd.getStandardOutput());
    }

    @Override
    public void rebaseAbort(Option ... options) throws BazaarClientException {
        RebaseAbort cmd = new RebaseAbort(this.workDir);
        this.setOptions(cmd, options);
        this.run(cmd);
        this.notificationHandler.logCompleted(cmd.getStandardOutput());
    }

    public void setOptions(Command cmd, Option ... options) {
        for (Option option : options) {
            cmd.setOption(option);
        }
    }

    public static boolean isAvailable(boolean force) throws BazaarClientException {
        boolean bl = force ? !force : (alreadyAskedForAvailability = alreadyAskedForAvailability);
        if (!alreadyAskedForAvailability) {
            available = CommandLineClient.checkXmlOutputVersion(XMLOUTPUT_VERSION);
            if (!available) {
                StringBuilder requiredVersion = new StringBuilder();
                requiredVersion.append(XMLOUTPUT_VERSION[0]).append(".");
                requiredVersion.append(XMLOUTPUT_VERSION[1]).append(".");
                requiredVersion.append(XMLOUTPUT_VERSION[2]);
                throw new BazaarClientException("xmloutput >= " + requiredVersion.toString() + " plugin not found");
            }
            alreadyAskedForAvailability = available;
        }
        return available;
    }

    public static boolean checkXmlOutputVersion(int[] requiredVersion) {
        int required;
        int major;
        int minor;
        String[] version = null;
        try {
            version = BazaarUtilities.getXmlOutputVersion();
        }
        catch (BazaarClientException e) {
            // empty catch block
        }
        if (version == null || version.length == 0) {
            return false;
        }
        int point = Integer.valueOf(version[2]);
        int actual = point + (minor = Integer.valueOf(version[1]).intValue()) * 100 + (major = Integer.valueOf(version[0]).intValue()) * 10000;
        return actual >= (required = requiredVersion[2] + requiredVersion[1] * 100 + requiredVersion[0] * 10000);
    }

    static {
        XMLOUTPUT_VERSION = new int[]{0, 9, 0};
    }
}

