/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.client.commandline;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.vcs.bazaar.client.BazaarRevision;
import org.vcs.bazaar.client.IBazaarLogMessage;
import org.vcs.bazaar.client.IBazaarStatus;
import org.vcs.bazaar.client.commandline.CommandLineException;
import org.vcs.bazaar.client.utils.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandLineLogMessage
implements IBazaarLogMessage {
    private static final long serialVersionUID = 77692323438797051L;
    private final String timestamp;
    private final List<IBazaarStatus> files;
    private final String commiter;
    private final String author;
    private final String revno;
    private final String nick;
    private final String message;
    private final List<IBazaarLogMessage> merged;
    private final String revisionId;
    private final List<String> parents;
    private final List<String> tags;

    public CommandLineLogMessage(String revno, String commiter, String author, String nick, String timestamp, String message, List<IBazaarStatus> resourceStatus, List<IBazaarLogMessage> merged, String revisionId, List<String> parents, List<String> tags) {
        this.revno = revno;
        this.commiter = commiter;
        this.nick = nick;
        this.timestamp = timestamp;
        this.message = message;
        this.files = Collections.unmodifiableList(resourceStatus == null ? Collections.EMPTY_LIST : resourceStatus);
        this.merged = Collections.unmodifiableList(merged == null ? Collections.EMPTY_LIST : merged);
        this.author = author;
        this.revisionId = revisionId;
        this.parents = Collections.unmodifiableList(parents == null ? Collections.EMPTY_LIST : parents);
        this.tags = Collections.unmodifiableList(tags == null ? Collections.EMPTY_LIST : tags);
    }

    public CommandLineLogMessage(String revno, String commiter, String nick, String timestamp, String message, List<IBazaarStatus> resourceStatus, List<IBazaarLogMessage> merged, String revisionId, List<String> parents, List<String> tags) {
        this(revno, commiter, null, nick, timestamp, message, resourceStatus, merged, revisionId, parents, tags);
    }

    @Override
    public String getBranchNick() {
        return this.nick;
    }

    @Override
    public String getCommiter() {
        return this.commiter;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public BazaarRevision getRevision() {
        return BazaarRevision.getRevision("revno:", this.revno);
    }

    @Override
    public String getTimeStamp() {
        return this.timestamp;
    }

    @Override
    public Date getDate() {
        try {
            return StringUtil.parseLogDate(this.timestamp);
        }
        catch (ParseException e) {
            throw CommandLineException.makeUnChecked(e);
        }
    }

    @Override
    public List<IBazaarStatus> getAffectedFiles() {
        return this.files;
    }

    @Override
    public List<IBazaarLogMessage> getMerged() {
        return this.merged;
    }

    @Override
    public List<IBazaarStatus> getAffectedFiles(boolean includeMerges) {
        if (includeMerges) {
            ArrayList<IBazaarStatus> all = new ArrayList<IBazaarStatus>();
            all.addAll(this.files);
            for (IBazaarLogMessage log : this.getMerged()) {
                for (IBazaarStatus status : log.getAffectedFiles()) {
                    if (all.contains(status)) continue;
                    all.add(status);
                }
            }
            return all;
        }
        return this.getAffectedFiles();
    }

    @Override
    public String getAuthor() {
        if (this.author == null) {
            return this.getCommiter();
        }
        return this.author;
    }

    @Override
    public List<String> getParents() {
        return this.parents;
    }

    @Override
    public String getRevisionId() {
        return this.revisionId;
    }

    @Override
    public List<String> getTags() {
        return this.tags;
    }

    @Override
    public int hasMerge() {
        List<IBazaarLogMessage> merges = this.getMerged();
        if (merges != null) {
            return merges.size();
        }
        return 0;
    }
}

