/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.client.commandline;

import java.io.File;
import org.vcs.bazaar.client.BazaarStatus;
import org.vcs.bazaar.client.BazaarStatusKind;
import org.vcs.bazaar.client.IBazaarStatus;
import org.vcs.bazaar.client.utils.BazaarUtilities;

public class CommandLineStatus
extends BazaarStatus {
    private static final long serialVersionUID = 6487875028464565954L;
    private File previousFile;
    private String oldKind;
    private String newKind;

    public CommandLineStatus(BazaarStatusKind statusKind, File path, boolean directory, File previousPath, String newKind, String oldKind, File branchRoot) {
        super(path, directory, branchRoot);
        this.previousFile = previousPath;
        this.newKind = newKind;
        this.oldKind = oldKind;
        this.statuses.add(statusKind);
    }

    public final String getNewKind() {
        if (this.statuses.contains((Object)BazaarStatusKind.KIND_CHANGED)) {
            return this.newKind;
        }
        return "";
    }

    public final String getOldKind() {
        if (this.statuses.contains((Object)BazaarStatusKind.KIND_CHANGED)) {
            return this.oldKind;
        }
        return "";
    }

    public final String getPreviousPath() {
        if (this.previousFile != null) {
            return BazaarUtilities.unixFilePath(this.previousFile);
        }
        return "";
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        if (!"".equals(this.getNewKind())) {
            sb.append("newkind: ").append(this.getNewKind());
        }
        if (!"".equals(this.getOldKind())) {
            sb.append("oldkind: ").append(this.getOldKind());
        }
        if (!"".equals(this.getPreviousPath())) {
            sb.append("prevPath: ").append(this.getPreviousPath());
        }
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof IBazaarStatus) {
            boolean equalPath = ((IBazaarStatus)obj).getPath().equals(this.getPath());
            return equalPath && this.statuses.containsAll(((IBazaarStatus)obj).getStatuses());
        }
        return super.equals(obj);
    }

    public int hashCode() {
        int PRIME = 31;
        int result = super.hashCode();
        result = 31 * result + (this.newKind == null ? 0 : this.newKind.hashCode());
        result = 31 * result + (this.oldKind == null ? 0 : this.oldKind.hashCode());
        result = 31 * result + (this.previousFile == null ? 0 : this.previousFile.hashCode());
        result = 31 * result + (this.file == null ? 0 : this.file.hashCode());
        result = 31 * result + (this.branchRoot == null ? 0 : this.branchRoot.hashCode());
        return result;
    }

    public File getPreviousFile() {
        return this.previousFile;
    }

    public final void merge(IBazaarStatus status) {
        if (status.contains(BazaarStatusKind.KIND_CHANGED)) {
            this.oldKind = status.getOldKind();
            this.newKind = status.getNewKind();
        }
        if (status.contains(BazaarStatusKind.RENAMED)) {
            this.previousFile = status.getPreviousFile();
        }
        this.statuses.addAll(status.getStatuses());
    }
}

