/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.client.commandline.internal;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.vcs.bazaar.client.BazaarClientPreferences;
import org.vcs.bazaar.client.BazaarPreference;
import org.vcs.bazaar.client.IBazaarPromptUserPassword;
import org.vcs.bazaar.client.commandline.internal.Command;
import org.vcs.bazaar.client.commandline.parser.XMLParser;
import org.vcs.bazaar.client.core.BazaarClientException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CommandRunner {
    private static HashMap<String, String> DEFAULT_ENVIROMENT = new HashMap();
    protected String stderr;
    protected String stdout;
    protected boolean checkExitValue;
    protected IBazaarPromptUserPassword userPasswordPrompt;

    public CommandRunner(boolean checkExitValue) {
        this.checkExitValue = checkExitValue;
    }

    public abstract void runCommand(Command var1, File var2) throws IOException, InterruptedException, BazaarClientException;

    public String getStandardError() {
        return this.stderr;
    }

    public String getStandardOutput() {
        return this.stdout;
    }

    public String getStandardOutput(String charsetName) throws UnsupportedEncodingException {
        return new String(this.stdout.getBytes(), charsetName);
    }

    public String[] getStandardOutputSplit() {
        return this.getStandardOutput().trim().split(this.getSplitExpression());
    }

    protected abstract String getSplitExpression();

    static void setDefaultEnviroment(ProcessBuilder pb) {
        Map<String, String> env = pb.environment();
        env.putAll(DEFAULT_ENVIROMENT);
        env.putAll(BazaarClientPreferences.getInstance().getPreferences());
    }

    public static ProcessBuilder createProcessBuilderWith(List<String> args) {
        ProcessBuilder pb = new ProcessBuilder(args);
        CommandRunner.setDefaultEnviroment(pb);
        return pb;
    }

    protected String decodeXMLOutput(byte[] output) {
        if (output == null) {
            return null;
        }
        String decodedWithDefaultCharset = new String(output);
        String stringEncoding = XMLParser.getDeclaredEncoding(decodedWithDefaultCharset);
        if (stringEncoding == null) {
            return decodedWithDefaultCharset;
        }
        try {
            return new String(output, stringEncoding);
        }
        catch (UnsupportedEncodingException e) {
            return decodedWithDefaultCharset;
        }
    }

    public void setPasswordCallback(IBazaarPromptUserPassword callback) {
        this.userPasswordPrompt = callback;
    }

    static {
        DEFAULT_ENVIROMENT.put(BazaarPreference.BZR_PROGRESS_BAR.name(), "xmlrpc");
    }
}

