/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.client.commandline.internal;

import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.util.List;
import org.vcs.bazaar.client.BazaarClientPreferences;
import org.vcs.bazaar.client.commandline.CommandLineException;
import org.vcs.bazaar.client.commandline.internal.Command;
import org.vcs.bazaar.client.commandline.internal.CommandRunner;
import org.vcs.bazaar.client.utils.Assert;
import org.vcs.bazaar.client.utils.StreamRedirect;

public class ShellCommandRunner
extends CommandRunner {
    public ShellCommandRunner(boolean checkExitValue) {
        super(checkExitValue);
    }

    public void runCommand(Command command, File workDir) throws IOException, InterruptedException, CommandLineException {
        List<String> cmdLine = command.constructCommandInvocationString();
        Assert.isNotNull(cmdLine);
        Assert.isTrue(cmdLine.size() > 0);
        cmdLine.addAll(0, BazaarClientPreferences.getExecutable(true));
        StringWriter outStream = new StringWriter();
        StringWriter errStream = new StringWriter();
        ProcessBuilder pb = new ProcessBuilder(cmdLine);
        ShellCommandRunner.setDefaultEnviroment(pb);
        if (workDir != null) {
            pb.directory(workDir);
        }
        Process proc = pb.start();
        String outName = "output_redirect";
        String errName = "error_redirect";
        StreamRedirect outRedirect = new StreamRedirect(outName, proc.getInputStream(), outStream);
        StreamRedirect errRedirect = new StreamRedirect(errName, proc.getErrorStream(), errStream);
        outRedirect.start();
        errRedirect.start();
        proc.waitFor();
        outRedirect.join();
        errRedirect.join();
        if (this.checkExitValue && proc.exitValue() != 0) {
            IOException e = new IOException(errStream.toString());
            e.setStackTrace(CommandLineException.getCurrentStackTrace());
            this.stderr = errStream.toString();
            throw e;
        }
        proc.exitValue();
        this.stderr = errStream.toString();
        this.stdout = outStream.toString();
    }

    protected String getSplitExpression() {
        return System.getProperty("line.separator");
    }
}

