/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.client.commandline.parser;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.kxml2.io.KXmlParser;
import org.vcs.bazaar.client.BazaarTag;
import org.vcs.bazaar.client.IBazaarTag;
import org.vcs.bazaar.client.commandline.parser.XMLParser;
import org.vcs.bazaar.client.core.BazaarClientException;
import org.xmlpull.v1.XmlPullParserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLTagsParser
extends XMLParser {
    private static final String TAGS = "tags";
    private static final String TAG = "tag";
    private static final String NAME = "name";
    private static final String REVISION = "revision";

    public static List<IBazaarTag> parse(String xml) throws BazaarClientException {
        KXmlParser parser = new KXmlParser();
        try {
            parser.setInput((Reader)new StringReader(xml));
            return new XMLTagsParser().parse(parser);
        }
        catch (XmlPullParserException e) {
            throw BazaarClientException.wrapException((Exception)((Object)e));
        }
    }

    public List<IBazaarTag> parse(KXmlParser aParser) throws BazaarClientException {
        ArrayList<IBazaarTag> tags = new ArrayList<IBazaarTag>();
        this.parser = aParser;
        try {
            this.parser.nextTag();
            this.parser.require(2, null, TAGS);
            int eventType = this.parser.getEventType();
            while (!(eventType == 1 || eventType == 3 && TAGS.equals(this.parser.getName()))) {
                IBazaarTag tag;
                if (eventType == 2 && TAG.equals(this.parser.getName()) && (tag = this.parseTag()) != null) {
                    tags.add(tag);
                }
                eventType = this.parser.next();
            }
            return tags;
        }
        catch (XmlPullParserException e) {
            throw BazaarClientException.wrapException((Exception)((Object)e));
        }
        catch (IOException e) {
            throw BazaarClientException.wrapException(e);
        }
    }

    private IBazaarTag parseTag() throws XmlPullParserException, IOException {
        String name = null;
        String revno = null;
        int eventType = this.parser.next();
        while (!(eventType == 1 || eventType == 3 && TAG.equals(this.parser.getName()))) {
            if (eventType == 2 && NAME.equals(this.parser.getName())) {
                name = this.parser.nextText();
            } else if (eventType == 2 && REVISION.equals(this.parser.getName()) && "?".equals(revno = this.parser.nextText())) {
                revno = null;
            }
            eventType = this.parser.next();
        }
        return new BazaarTag(name, revno);
    }
}

