/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.client.core;

import java.io.File;
import java.io.Serializable;
import java.net.URI;
import org.vcs.bazaar.client.core.BazaarClientException;
import org.vcs.bazaar.client.utils.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BranchLocation
implements Comparable<BranchLocation>,
Serializable {
    private static final long serialVersionUID = 6174757231086380623L;
    Scheme scheme;
    URI uri = null;
    String raw = null;
    private static final Scheme[] SCHEMES = new Scheme[]{new Scheme("file", true), new Scheme("bzr", true), new Scheme("bzr+ssh", true), new Scheme("lp", true), new Scheme("aftp", true), new Scheme("sftp", true), new Scheme("ftp", true), new Scheme("rsync", true), new Scheme("http", false), new Scheme("https", false), new Scheme("bzr+http", false), new Scheme("bzr+https", false), new Scheme("https+urllib", false)};

    private static Scheme lookupScheme(String schemeId) throws BazaarClientException {
        for (Scheme s : SCHEMES) {
            if (!s.id.equals(schemeId)) continue;
            return s;
        }
        throw new BazaarClientException("Unsupported Scheme");
    }

    public BranchLocation(String raw) throws BazaarClientException {
        if (raw == null || raw.trim().isEmpty()) {
            throw new BazaarClientException("Branch Not Specified");
        }
        this.raw = raw = raw.trim();
        if (raw.startsWith("lp:")) {
            if (raw.length() == 3) {
                throw new BazaarClientException("Branch Not Specified");
            }
            this.scheme = BranchLocation.lookupScheme("lp");
            return;
        }
        if (!raw.matches("^[a-zA-Z]:.*")) {
            try {
                this.uri = new URI(StringUtil.encodeURI(raw));
                if (this.uri.getScheme() != null) {
                    this.scheme = BranchLocation.lookupScheme(this.uri.getScheme());
                    return;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.initAsFile(new File(raw));
    }

    public BranchLocation(URI uri) throws BazaarClientException {
        this.uri = uri;
        if (uri == null) {
            throw new BazaarClientException("Branch Not Specified");
        }
        String schemeId = uri.getScheme();
        if (schemeId == null || schemeId.matches("^[a-zA-Z]$")) {
            this.initAsFile(new File(uri.getPath()));
        } else {
            this.scheme = BranchLocation.lookupScheme(schemeId);
        }
    }

    public BranchLocation(File file) throws BazaarClientException {
        if (file == null) {
            throw new BazaarClientException("Branch Not Specified");
        }
        this.initAsFile(file);
    }

    private void initAsFile(File file) throws BazaarClientException {
        File parent = file.getParentFile();
        if (!(file.exists() || parent != null && parent.exists())) {
            throw new BazaarClientException("File not found");
        }
        this.raw = file.getAbsolutePath();
        this.scheme = BranchLocation.lookupScheme("file");
        this.uri = file.toURI();
    }

    public boolean isWriteable() {
        return this.scheme.writeable;
    }

    public String toString() {
        if (this.raw != null) {
            return this.raw;
        }
        return this.uri.toString();
    }

    @Override
    public int compareTo(BranchLocation other) {
        String location = this.toString();
        if (location == null) {
            return -1;
        }
        return location.compareTo(other.toString());
    }

    public int hashCode() {
        String location = this.toString();
        int prime = 31;
        int result = 1;
        result = 31 * result + (location == null ? 0 : location.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BranchLocation other = (BranchLocation)obj;
        String location = this.toString();
        return !(location == null ? other.toString() != null : !location.equals(other.toString()));
    }

    public String getScheme() {
        return this.scheme.id;
    }

    public URI getUri() {
        return this.uri;
    }

    public String getRaw() {
        return this.raw;
    }

    private static class Scheme
    implements Serializable {
        private static final long serialVersionUID = 1L;
        String id;
        boolean writeable;

        Scheme(String i, boolean w) {
            this.id = i;
            this.writeable = w;
        }
    }
}

