/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.client.xmlrpc.internal;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.util.List;
import org.vcs.bazaar.client.BazaarClientPreferences;
import org.vcs.bazaar.client.BazaarPreference;
import org.vcs.bazaar.client.IBazaarProgressListener;
import org.vcs.bazaar.client.commandline.internal.Command;
import org.vcs.bazaar.client.commandline.internal.CommandRunner;
import org.vcs.bazaar.client.core.BazaarClientException;
import org.vcs.bazaar.client.xmlrpc.BzrXmlRpcError;
import org.vcs.bazaar.client.xmlrpc.XmlRpcCommandException;
import org.vcs.bazaar.client.xmlrpc.XmlRpcMethod;
import org.vcs.bazaar.client.xmlrpc.internal.XMLRPCServer;
import redstone.xmlrpc.XmlRpcArray;
import redstone.xmlrpc.XmlRpcClient;
import redstone.xmlrpc.XmlRpcException;
import redstone.xmlrpc.XmlRpcFault;

public class XMLRPCCommandRunner
extends CommandRunner {
    private static final String DEFAULT_PORT = "11111";
    private static final XMLRPCServer SERVICE = new XMLRPCServer();
    protected XmlRpcArray result;

    /*
     * Exception decompiling
     */
    private XmlRpcArray runCommand(Command command, boolean checkExitValue, File workDir) throws XmlRpcCommandException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [12[CATCHBLOCK], 3[TRYBLOCK]], but top level block is 8[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static XmlRpcArray runCommand(boolean checkExitValue, String methodName, Object[] params) throws XmlRpcCommandException {
        try {
            String port = XMLRPCCommandRunner.getServicePort();
            XmlRpcClient client = new XmlRpcClient("http://127.0.0.1:" + port + "/RPC2", false);
            XmlRpcArray result = (XmlRpcArray)client.invoke(methodName, params);
            if (checkExitValue && result.getInteger(0) != 0 && !"".equals(result.getString(2))) {
                XmlRpcCommandException e = new XmlRpcCommandException(BzrXmlRpcError.fromXml(result.getString(2)));
                e.setStackTrace(XmlRpcCommandException.getCurrentStackTrace());
                throw e;
            }
            return result;
        }
        catch (XmlRpcFault fault) {
            XmlRpcCommandException e = null;
            try {
                e = new XmlRpcCommandException(BzrXmlRpcError.fromXml(fault.getMessage()));
                e.setStackTrace(BazaarClientException.getCurrentStackTrace());
            }
            catch (Exception e1) {
                e = XmlRpcCommandException.wrapException((Exception)((Object)fault));
            }
            throw e;
        }
        catch (MalformedURLException e) {
            throw XmlRpcCommandException.wrapException(e);
        }
    }

    static Object executeMethod(String method, XmlRpcArray params) throws XmlRpcCommandException {
        try {
            String port = XMLRPCCommandRunner.getServicePort();
            XmlRpcClient client = new XmlRpcClient("http://127.0.0.1:" + port + "/RPC2", false);
            Object result = client.invoke(method, (List)params);
            return result;
        }
        catch (XmlRpcFault e) {
            throw XmlRpcCommandException.wrapException((Exception)((Object)e));
        }
        catch (MalformedURLException e) {
            throw XmlRpcCommandException.wrapException(e);
        }
    }

    private static String getServicePort() {
        String port = DEFAULT_PORT;
        if (SERVICE.getPort() != null && !"".equals(SERVICE.getPort())) {
            port = SERVICE.getPort();
        }
        return port;
    }

    private static void checkServiceStatus() {
        if (!XMLRPCServer.isAlive()) {
            SERVICE.run();
        } else if (SERVICE.getPort() != null && !SERVICE.getPort().equals(BazaarClientPreferences.getInstance().getString(BazaarPreference.BZR_XMLRPC_PORT))) {
            XMLRPCServer.destroy();
            SERVICE.run();
        }
    }

    public XMLRPCCommandRunner(boolean checkExitValue) {
        super(checkExitValue);
        XMLRPCCommandRunner.checkServiceStatus();
    }

    protected String getSplitExpression() {
        return "\n";
    }

    public void runCommand(final Command command, final File workDir) throws BazaarClientException {
        this.result = (XmlRpcArray)new SafeXmlRPCCall<XmlRpcArray>(){

            @Override
            public XmlRpcArray internalExecute() throws XmlRpcCommandException {
                return XMLRPCCommandRunner.this.runCommand(command, XMLRPCCommandRunner.this.checkExitValue, workDir);
            }
        }.execute();
    }

    public Object executeMethod(final XmlRpcMethod method) throws BazaarClientException {
        final XmlRpcArray arguments = new XmlRpcArray();
        for (Object arg : method.getArguments()) {
            arguments.add(arg);
        }
        return new SafeXmlRPCCall<Object>(){

            @Override
            public Object internalExecute() throws XmlRpcCommandException {
                return XMLRPCCommandRunner.executeMethod(method.getName(), arguments);
            }
        }.execute();
    }

    public String getStandardOutput() {
        return this.decodeXMLOutput(this.result.getBinary(1));
    }

    public String getStandardOutput(String charsetName) throws UnsupportedEncodingException {
        return new String(this.result.getBinary(1), charsetName);
    }

    public String getStandardError() {
        return this.result.getString(2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class XMLRPCProgressMonitor
    implements Runnable {
        private boolean running;
        private List<String> cmdLine;
        private final IBazaarProgressListener listener;

        public XMLRPCProgressMonitor(List<String> cmdLine, IBazaarProgressListener listener) {
            this.listener = listener;
            this.cmdLine = cmdLine;
        }

        @Override
        public void run() {
            while (this.running) {
                try {
                    Thread.sleep(250L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                if (!this.running) continue;
                try {
                    int port = Integer.parseInt(XMLRPCCommandRunner.getServicePort()) + 1;
                    Object[] params = new Object[]{this.cmdLine};
                    XmlRpcClient client = new XmlRpcClient("http://127.0.0.1:" + port + "/RPC2", false);
                    String result = (String)client.invoke("get_bzr_progress", params);
                    if (result == null) continue;
                    String progress = result;
                    this.listener.logProgress(progress);
                }
                catch (Exception e) {
                    this.running = false;
                }
            }
        }

        public void start() {
            this.running = true;
            Thread t = new Thread(this);
            t.setDaemon(true);
            t.start();
        }

        public void stop() {
            this.running = false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static abstract class SafeXmlRPCCall<T> {
        protected SafeXmlRPCCall() {
        }

        public T execute() throws XmlRpcCommandException {
            try {
                return this.internalExecute();
            }
            catch (XmlRpcException e) {
                XMLRPCCommandRunner.checkServiceStatus();
                try {
                    return this.internalExecute();
                }
                catch (XmlRpcException e1) {
                    throw XmlRpcCommandException.wrapException((Exception)((Object)e1));
                }
            }
        }

        public abstract T internalExecute() throws XmlRpcCommandException;
    }
}

