/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.client.xmlrpc.internal;

import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import org.vcs.bazaar.client.BazaarClientPreferences;
import org.vcs.bazaar.client.BazaarPreference;
import org.vcs.bazaar.client.IBzrError;
import org.vcs.bazaar.client.commandline.internal.CommandRunner;
import org.vcs.bazaar.client.core.BazaarClientException;
import org.vcs.bazaar.client.utils.StreamRedirect;
import org.vcs.bazaar.client.xmlrpc.XmlRpcCommandException;
import org.vcs.bazaar.client.xmlrpc.internal.XMLRPCCommandRunner;
import redstone.xmlrpc.XmlRpcArray;
import redstone.xmlrpc.XmlRpcException;

public class XMLRPCServer
implements Runnable {
    private static final int SLEEP_TIME = 200;
    private static final String START_XMLRPC = "start-xmlrpc";
    private static final String PORT_OPTION = "--port=";
    private static Process xmlRpcService;
    private String port;
    private final StringWriter serviceStdErr = new StringWriter();

    public XMLRPCServer() {
        Runtime.getRuntime().addShutdownHook(new ServerKiller());
    }

    public void run() {
        block10: {
            try {
                if (XMLRPCServer.testConnection()) {
                    return;
                }
            }
            catch (XmlRpcCommandException e) {
                IBzrError error = e.getCommandError();
                if (error == null || !error.getType().equals("unknown") || !error.getMessage().contains("Broken pipe")) break block10;
                XMLRPCServer.destroy();
            }
        }
        ArrayList<String> args = new ArrayList<String>();
        args.addAll(BazaarClientPreferences.getExecutable(true));
        args.add(START_XMLRPC);
        this.port = BazaarClientPreferences.getInstance().getString(BazaarPreference.BZR_XMLRPC_PORT);
        if (this.port != null && !"".equals(this.port)) {
            args.add(PORT_OPTION + this.port);
        }
        ProcessBuilder pb = CommandRunner.createProcessBuilderWith(args);
        try {
            xmlRpcService = pb.start();
            StreamRedirect srout = new StreamRedirect("xmlrpc-service_stdout>null", xmlRpcService.getInputStream(), null);
            StreamRedirect srerr = new StreamRedirect("xmlrpc-service_stderr>null", xmlRpcService.getErrorStream(), this.serviceStdErr);
            srout.start();
            srerr.start();
            boolean connect = false;
            while (!connect) {
                connect = XMLRPCServer.isConnected();
                try {
                    if (connect || XMLRPCServer.isConnected()) continue;
                    xmlRpcService.exitValue();
                    throw new BazaarClientException.BazaarUncheckedException(this.serviceStdErr.toString());
                }
                catch (IllegalThreadStateException e) {
                    Thread.sleep(200L);
                }
            }
        }
        catch (IOException ioex) {
            throw new RuntimeException(ioex);
        }
        catch (InterruptedException intex) {
            throw new RuntimeException(intex);
        }
    }

    private static boolean isConnected() throws InterruptedException {
        try {
            return XMLRPCServer.testConnection();
        }
        catch (BazaarClientException ioex) {
            Thread.sleep(200L);
            return false;
        }
    }

    private static boolean testConnection() throws XmlRpcCommandException {
        try {
            String result = (String)XMLRPCCommandRunner.executeMethod("hello", new XmlRpcArray());
            return result != null && result.equals("world!");
        }
        catch (XmlRpcException e) {
            return false;
        }
    }

    public static boolean isAlive() {
        if (xmlRpcService == null) {
            XMLRPCServer.destroy();
            return false;
        }
        try {
            if (!XMLRPCServer.testConnection()) {
                xmlRpcService.exitValue();
                return false;
            }
            return true;
        }
        catch (IllegalThreadStateException e) {
            return true;
        }
        catch (XmlRpcCommandException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void destroy() {
        try {
            XMLRPCCommandRunner.executeMethod("quit", new XmlRpcArray());
        }
        catch (Exception exception) {
        }
        finally {
            if (xmlRpcService != null) {
                xmlRpcService.destroy();
            }
        }
    }

    public String getPort() {
        return this.port;
    }

    static class ServerKiller
    extends Thread {
        ServerKiller() {
        }

        public void run() {
            try {
                XMLRPCServer.destroy();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

