/**
 *
 */
package org.vcs.bazaar.client;

/**
 * @author Guillermo Gonzalez <guillo.gonzo@gmail.com>
 *
 */
public class BazaarVersion {

    private final String version;
    private final String bzrlib;
    private final String configuration;
    private final String logFile;
    private final String copyright;

    public BazaarVersion(String version, String bzrlib, String configuration,
            String logFile, String copyright) {
        this.version = version;
        this.bzrlib = bzrlib;
        this.configuration = configuration;
        this.logFile = logFile;
        this.copyright = copyright;
    }

    /**
     * @return the version
     */
    public final String getVersion() {
        return version;
    }

    /**
     * @return the bzrlib path
     */
    public final String getBzrlib() {
        return bzrlib;
    }

    /**
     * @return the configuration path
     */
    public final String getConfiguration() {
        return configuration;
    }

    /**
     * @return the logFile path
     */
    public final String getLogFile() {
        return logFile;
    }

    /**
     * @return the copyright
     */
    public final String getCopyright() {
        return copyright;
    }


}
