/**
 * LICENCSE + COPYRIGHT
 */
package org.vcs.bazaar.client.commandline;

import org.vcs.bazaar.client.BazaarClientFactory;
import org.vcs.bazaar.client.IBazaarClient;
import org.vcs.bazaar.client.core.BazaarClientException;
import org.vcs.bazaar.client.utils.BazaarUtilities;

/**
 * @author Guillermo Gonzalez
 * 
 */
public class CommandLineClientFactory extends BazaarClientFactory {

	public static final String CLIENT_TYPE = "CommandLine";
	protected boolean alreadyAskedForAvailability;
	protected boolean available;
	private final static int[] XMLOUTPUT_VERSION = new int[] { 0, 9, 2 };
	private final static int POINT = 2;
	private final static int MINOR = 1;
	private final static int MAJOR = 0;

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.vcs.bazaar.client.BazaarClientFactory#createClientImpl()
	 */
	@Override
	protected IBazaarClient createClientImpl() {
		return new CommandLineClient(new CommandLineNotificationHandler());
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.vcs.bazaar.client.BazaarClientFactory#getClientType()
	 */
	@Override
	protected String getClientType() {
		return CLIENT_TYPE;
	}

	public static boolean checkXmlOutputVersion(int[] requiredVersion) {
		String[] version = null;
		try {
			version = BazaarUtilities.getXmlOutputVersion();
		} catch (BazaarClientException e) {
		}
		if (version == null || version.length == 0) {
			return false;
		}
		int point = Integer.valueOf(version[POINT]);
		int minor = Integer.valueOf(version[MINOR]);
		int major = Integer.valueOf(version[MAJOR]);
		int required = requiredVersion[POINT] + requiredVersion[MINOR] * 100 + requiredVersion[MAJOR] * 10000;
		int actual = point + minor * 100 + major * 10000;
		return actual >= required;
	}

	@Override
	protected boolean isAvailable(boolean force) throws BazaarClientException {
		alreadyAskedForAvailability = force ? !force : alreadyAskedForAvailability;
		if (!alreadyAskedForAvailability) {
			BazaarUtilities.checkExecutable();
			available = checkXmlOutputVersion(XMLOUTPUT_VERSION);
			if (!available) {
				StringBuilder requiredVersion = new StringBuilder();
				requiredVersion.append(XMLOUTPUT_VERSION[MAJOR]).append(".");
				requiredVersion.append(XMLOUTPUT_VERSION[MINOR]).append(".");
				requiredVersion.append(XMLOUTPUT_VERSION[POINT]);
				throw new BazaarClientException("xmloutput >= " + requiredVersion.toString() + " plugin not found");
			}
			alreadyAskedForAvailability = available;
		}
		return available;
	}

}
