/**
 * LICENSE + COPYRIGHT
 */
package org.vcs.bazaar.client.commandline.commands;

import java.io.File;
import java.util.List;

import org.vcs.bazaar.client.commandline.syntax.INickOptions;

/**
 * @author Guillermo Gonzalez
 *
 */
public class Nick extends SingleFileCommand implements INickOptions {

	private final String newNick;

	/**
	 * This constructor is for setting the nick
	 *
	 * @param project
	 */
	public Nick(final File workDir, final String newNick) {
		super(workDir, null);
		this.newNick = newNick;
	}

	/**
	 * This constructor is for getting the nick
	 *
	 * @param project
	 */
	public Nick(final File workDir) {
		super(workDir, null);
		this.newNick = null;
	}

	/*
	 * (non-Javadoc)
	 *
	 * @see org.vcs.bazaar.client.core.commands.Command#getArguments()
	 */
	@Override
	protected List<String> getArguments() {
		return getArguments(newNick);
	}

	/*
	 * (non-Javadoc)
	 *
	 * @see org.vcs.bazaar.client.core.commands.Command#getCommand()
	 */
	@Override
	public String getCommand() {
		return COMMAND;
	}

}
