/**
 * LICENSE + COPYRIGHT
 */
package org.vcs.bazaar.client.commandline.commands;

import java.util.ArrayList;
import java.util.List;

import org.vcs.bazaar.client.commandline.CommandLineException;
import org.vcs.bazaar.client.commandline.internal.Command;
import org.vcs.bazaar.client.commandline.internal.CommandRunner;
import org.vcs.bazaar.client.commandline.syntax.IPluginsOptions;
import org.vcs.bazaar.client.core.BazaarClientException;

/**
 * @author Guillermo Gonzalez <guillo.gonzo AT gmail DOT com>
 *
 */
public class Plugins extends Command implements IPluginsOptions {

	public Plugins() {
		super();
	}


	@Override
	public void execute(CommandRunner runner) throws BazaarClientException {
		super.execute(runner);
		String err = getStandardError();
		if(!"".equals(err)) {
			throw new CommandLineException(err, COMMAND);
		}

	}
	@Override
	public String getCommand() {
		return IPluginsOptions.COMMAND;
	}

	@Override
	protected List<String> getArguments() {
		return new ArrayList<String>();
	}

}