package org.vcs.bazaar.client.commandline.commands;

import java.io.File;
import java.util.List;

import org.vcs.bazaar.client.commandline.internal.CommandWithProgressListener;
import org.vcs.bazaar.client.core.BranchLocation;

public abstract class SingleLocationCommand extends CommandWithProgressListener {

	protected BranchLocation location;
	
	public SingleLocationCommand(File workDir, BranchLocation location) {
		super(workDir);
		this.location = location;
	}
	
	@Override
	protected List<String> getArguments() {
		if (location == null) {
			return getEmptyArguments();
		}
		return getArguments(location.toString());
	}

}
