/**
 * LICENCSE + COPYRIGHT
 */
package org.vcs.bazaar.client.commandline.syntax;

import org.vcs.bazaar.client.commandline.commands.options.KeywordOption;
import org.vcs.bazaar.client.commandline.commands.options.Option;

/**
 * @author Piotr Piastucki
 */
public interface ICleanTreeOptions {

	public final static String COMMAND = "clean-tree"; //$NON-NLS-N$

	/**
	 * Display more information.
	 */
	public static final Option VERBOSE = new Option("--verbose"); //$NON-NLS-N$

	/**
	 * Reprocess to reduce spurious conflicts.
	 */
	public static final Option REPROCESS = new Option("--reprocess"); //$NON-NLS-N$

	/**
	 * Only display errors and warnings.
	 */
	public static final Option QUIET = new Option("--quiet"); //$NON-NLS-N$

	/**
	 * Branch to operate on, instead of working directory.
	 */
	public static final KeywordOption DIRECTORY = new KeywordOption("--directory", "ARG"); //$NON-NLS-N$

	/**
	 * Delete conflict files, merge and revert backups, and failed selftest dirs.
	 */
	public static final Option DETRITUS = new Option("--detritus"); //$NON-NLS-N$

	/**
	 * Do not prompt before deleting.
	 */
	public static final Option FORCE = new Option("--force"); //$NON-NLS-N$

	/**
	 * Show files to delete instead of deleting them.
	 */
	public static final Option DRY_RUN = new Option("--dry-run"); //$NON-NLS-N$

	/**
	 * Delete all ignored files.
	 */
	public static final Option IGNORED = new Option("--ignored"); //$NON-NLS-N$

	/**
	 * Delete files unknown to bzr (default).
	 */
	public static final Option UNKNOWN = new Option("--unknown"); //$NON-NLS-N$

}
