/**
 * LICENCSE + COPYRIGHT
 */
package org.vcs.bazaar.client.commandline.syntax;

import org.vcs.bazaar.client.commandline.commands.options.KeywordOption;
import org.vcs.bazaar.client.commandline.commands.options.Option;

/**
 * @author Piotr Piastucki
 */
public interface IRebaseOptions {
	
	public final static String COMMAND = "rebase"; //$NON-NLS-N$

	/**
	 * Show what would be done, but don't actually do anything.
	 */
	public static final Option DRY_RUN = new Option("--dry-run"); //$NON-NLS-N$

	/**
	 * Rebase pending merges onto local branch.
	 */
	public static final Option PENDING_MERGES = new Option("--pending-merges"); //$NON-NLS-N$

	/**
	 * Display more information.
	 */
	public static final Option VERBOSE = new Option("--verbose"); //$NON-NLS-N$

	/**
	 * Only display errors and warnings.
	 */
	public static final Option QUIET = new Option("--quiet"); //$NON-NLS-N$

	/**
	 * Select a particular merge algorithm.
	 */
	public static final KeywordOption MERGE_TYPE = new KeywordOption("--merge-type", "ARG"); //$NON-NLS-N$

	/**
	 * Branch to merge into, rather than the one containing the working
	 * directory.
	 */
	public static final KeywordOption DIRECTORY = new KeywordOption("--directory", "ARG"); //$NON-NLS-N$

	/**
	 * Different revision to replay onto.
	 */
	public static final KeywordOption ONTO = new KeywordOption("--onto", "ARG"); //$NON-NLS-N$

	/**
	 * Don't skip revisions that merge already present revisions.
	 */
	public static final Option ALWAYS_REBASE_MERGES = new Option("--always-rebase-merges"); //$NON-NLS-N$

	/**
	 * See "help revisionspec" for details.
	 */
	public static final KeywordOption REVISION = new KeywordOption("--revision", "ARG"); //$NON-NLS-N$

	public final static String HELP = "Re-base a branch."; //$NON-NLS-N$

}
