/**
 * LICENCSE + COPYRIGHT
 */
package org.vcs.bazaar.client.commandline.syntax;

import org.vcs.bazaar.client.commandline.commands.options.KeywordOption;
import org.vcs.bazaar.client.commandline.commands.options.Option;

/**
 * @author Guillermo Gonzalez
 *
 */
public interface IReconfigureOptions {

	public final static String COMMAND = "reconfigure"; //$NON-NLS-N$

	/**
	 * Perform reconfiguration even if local changes will be lost.
	 */
	public static final Option FORCE = new Option("--force"); //$NON-NLS-N$

	/**
	 * Display more information.
	 */
	public static final Option VERBOSE = new Option("--verbose"); //$NON-NLS-N$

	/**
	 * Reconfigure a branch to be unstacked.  This may require copying substantial data into it.
	 */
	public static final Option UNSTACKED = new Option("--unstacked"); //$NON-NLS-N$

	/**
	 * Reconfigure a branch to be stacked on another branch.
	 */
	public static final KeywordOption STACKED_ON = new KeywordOption("--stacked-on", "ARG"); //$NON-NLS-N$

	/**
	 * Branch to bind checkout to.
	 */
	public static final KeywordOption BIND_TO = new KeywordOption("--bind-to", "ARG"); //$NON-NLS-N$
	
	/**
	 * Reconfigure to be an unbound branch with no working tree.
	 */
	public static final Option BRANCH = new Option("--branch"); //$NON-NLS-N$

	/**
	 * Reconfigure to be a bound branch with a working tree.
	 */
	public static final Option CHECKOUT = new Option("--checkout"); //$NON-NLS-N$

	/**
	 * Reconfigure to be a lightweight checkout (with no local history).
	 */
	public static final Option LIGHTWEIGHT_CHECKOUT = new Option("--lightweight-checkout"); //$NON-NLS-N$

	/**
	 * Reconfigure to be an unbound branch with a working tree.
	 */
	public static final Option TREE = new Option("--tree"); //$NON-NLS-N$

	/**
	 * Only display errors and warnings.
	 */
	public static final Option QUIET = new Option("--quiet"); //$NON-NLS-N$

	/**
	 * Reconfigure repository to not create working trees on branches by default.
	 */
	public static final Option WITH_NO_TREES = new Option("--with-no-trees"); //$NON-NLS-N$

	/**
	 * Reconfigure repository to create working trees on branches by default.
	 */
	public static final Option WITH_TREES = new Option("--with-trees"); //$NON-NLS-N$

	/**
	 * Reconfigure to be a standalone branch (i.e. stop using shared repository).
	 */
	public static final Option STANDALONE = new Option("--standalone"); //$NON-NLS-N$

	/**
	 * Reconfigure to use a shared repository.
	 */
	public static final Option USE_SHARED = new Option("--use-shared"); //$NON-NLS-N$
	
	public final static String HELP = "Reconfigure the type of a bzr directory."; //$NON-NLS-N$
}
