// Copyright (c) 2004-2006 by Leif Frenzel - see http://leiffrenzel.de
package org.vcs.bazaar.client.utils;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;

/**
 * <p>
 * A thread that copies the contents of an input stream to an output stream and
 * terminates when the input stream is finished.
 * </p>
 *
 * @author Leif Frenzel
 * @modifiedBy Guillermo Gonzalez <guillo.gonzo at gmail dot com>
 */
public class StreamRedirect implements Runnable {

	private static final int BUFFER_SIZE = 2048;

	private Thread theThread;

	private Reader in;

	private Writer out;

	private Exception ex;

	public StreamRedirect(final String name, final InputStream in, final Writer out) {
		this.in = new InputStreamReader(in);
		this.out = out;
		this.theThread = new Thread(this, name);
		theThread.setPriority(Thread.MAX_PRIORITY - 1);
	}

	public Exception getException() {
		return ex;
	}

	// interface methods of Runnable
	// //////////////////////////////////////

	public void run() {
		try {
			char[] cbuf = new char[BUFFER_SIZE];
			int count;
			while ((count = in.read(cbuf, 0, BUFFER_SIZE)) >= 0) {
				if(out != null) {
					out.write(cbuf, 0, count);
					out.flush();
				}
			}
		} catch (IOException ex) {
			this.ex = ex;
		}
	}

	public void start() {
		theThread.start();
	}

	public void join() throws InterruptedException {
		theThread.join();
	}

}