/**
 * LICENCSE + COPYRIGHT
 */
package org.vcs.bazaar.client.xmlrpc;

import org.vcs.bazaar.client.IBazaarClient;
import org.vcs.bazaar.client.commandline.CommandLineClientFactory;
import org.vcs.bazaar.client.commandline.CommandLineNotificationHandler;
import org.vcs.bazaar.client.core.BazaarClientException;

/**
 * @author Guillermo Gonzalez
 *
 */
public class XmlRpcClientFactory extends CommandLineClientFactory {

	public static final String CLIENT_TYPE = "XmlRpcClient";

	/*
	 * (non-Javadoc)
	 *
	 * @see org.vcs.bazaar.client.BazaarClientFactory#createClientImpl()
	 */
	@Override
	protected IBazaarClient createClientImpl() {
		return new XmlRpcClient(new CommandLineNotificationHandler());
	}

	/*
	 * (non-Javadoc)
	 *
	 * @see org.vcs.bazaar.client.BazaarClientFactory#getClientType()
	 */
	@Override
	protected String getClientType() {
		return CLIENT_TYPE;
	}

	@Override
	protected boolean isAvailable(boolean force) throws BazaarClientException {
		// TODO: Add connectivity check (i.e. start up xmlrpc server and ping it)
		return super.isAvailable(force);
	}

}
