/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.client.commandline.parser;

import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;
import org.vcs.bazaar.client.IBazaarInfo;
import org.vcs.bazaar.client.commandline.parser.XMLInfoParser;
import org.vcs.bazaar.client.core.BazaarClientException;
import org.vcs.bazaar.client.testUtils.ParserTest;

public class XMLInfoParserTest
extends ParserTest {
    @Test
    public void testSimpleLog() throws BazaarClientException, IOException {
        IBazaarInfo info = null;
        XMLInfoParser parser = new XMLInfoParser();
        info = parser.parse(XMLInfoParserTest.getContentsFrom("org/vcs/bazaar/client/commandline/parser/info.xml"));
        Assert.assertNotNull((Object)info);
        Assert.assertEquals((Object)"Repository tree", (Object)info.getLayout());
        Assert.assertEquals((long)1L, (long)info.getFormats().length);
        Assert.assertEquals((Object)"dirstate", (Object)info.getFormats()[0]);
        Assert.assertEquals((Object)"/home/guillo/bazaar/bzr", (Object)info.getLocations().getSharedRepository());
        Assert.assertEquals((Object)".", (Object)info.getLocations().getRepositoryBranch());
        Assert.assertEquals((Object)"http://bazaar.launchpad.net/~bzr/bzr/trunk/", (Object)info.getRelatedBranches().getParentBranch());
        Assert.assertEquals((Object)"Meta directory format 1", (Object)info.getControlFormat().trim());
        Assert.assertEquals((Object)"Working tree format 4", (Object)info.getWorkingTreeFormat().trim());
        Assert.assertEquals((Object)"Branch format 5", (Object)info.getBranchFormat().trim());
        Assert.assertEquals((Object)"Knit repository format 1", (Object)info.getRepositoryFormat().trim());
        Assert.assertEquals((long)735L, (long)info.getWorkingTreeStats().getUnchanged().intValue());
        Assert.assertEquals((long)0L, (long)info.getWorkingTreeStats().getModified().intValue());
        Assert.assertEquals((long)0L, (long)info.getWorkingTreeStats().getAdded().intValue());
        Assert.assertEquals((long)0L, (long)info.getWorkingTreeStats().getRemoved().intValue());
        Assert.assertEquals((long)0L, (long)info.getWorkingTreeStats().getRenamed().intValue());
        Assert.assertEquals((long)3L, (long)info.getWorkingTreeStats().getUnknown().intValue());
        Assert.assertEquals((long)73L, (long)info.getWorkingTreeStats().getIgnored().intValue());
        Assert.assertEquals((long)58L, (long)info.getWorkingTreeStats().getVersionedSubdirectories().intValue());
        Assert.assertEquals((long)2866L, (long)info.getBranchHistory().getRevisions().intValue());
        Assert.assertEquals((long)108L, (long)info.getBranchHistory().getCommitters().intValue());
        Assert.assertEquals((long)824L, (long)info.getBranchHistory().getDaysOld().intValue());
        Assert.assertEquals((long)13764L, (long)info.getRepositoryStats().getRevisionCount().intValue());
        Assert.assertEquals((long)63614L, (long)info.getRepositoryStats().getSize());
    }
}

