/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.client.testUtils;

import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.vcs.bazaar.client.BazaarTreeStatus;
import org.vcs.bazaar.client.commandline.commands.options.Option;
import org.vcs.bazaar.client.core.BranchLocation;
import org.vcs.bazaar.client.testUtils.ExpectedWorkingTree;
import org.vcs.bazaar.client.testUtils.FileUtils;
import org.vcs.bazaar.client.testUtils.TestConfig;
import org.vcs.bazaar.client.testUtils.TestsConfig;

public class Environment {
    private static final Log LOG = LogFactory.getLog(Environment.class);
    protected String testName;
    protected TestsConfig testsConfig = TestsConfig.getTestsConfig();
    protected File workingTreeLocation;
    protected ExpectedWorkingTree expectedWorkingTree;
    protected TestConfig config;

    public Environment(String testName, TestConfig config) throws Exception {
        this.testName = testName;
        this.config = config;
        this.expectedWorkingTree = config.getExpectedWorkingTree().copy();
        this.workingTreeLocation = this.createStartWorkingCopy(config.getWorkingTreeLocation(), testName);
    }

    protected File createStartWorkingCopy(File branch, String testName) throws Exception {
        this.workingTreeLocation = new File(this.testsConfig.workingCopies, testName);
        LOG.debug((Object)("Creating working copy at " + this.workingTreeLocation.toString()));
        this.workingTreeLocation.getParentFile().mkdirs();
        if (this.workingTreeLocation.exists()) {
            FileUtils.removeDirectoryWithContent(this.workingTreeLocation);
        }
        this.config.getClient().setWorkDir(branch.getParentFile());
        this.config.getClient().branch(new BranchLocation(branch), this.workingTreeLocation, null, new Option[0]);
        this.checkStatusesExpectedWorkingTree(this.getWorkingTreeLocation());
        return this.workingTreeLocation;
    }

    public void checkStatusesExpectedWorkingTree(File wtLocation) throws Exception {
        BazaarTreeStatus treeStatus = this.config.getClient().status(new File[]{wtLocation}, new Option[0]);
        this.expectedWorkingTree.check(treeStatus.getStatusAsArray(), this.workingTreeLocation.getAbsolutePath());
    }

    public ExpectedWorkingTree getExpectedWorkingTree() {
        return this.expectedWorkingTree;
    }

    public File getWorkingTreeLocation() {
        return this.workingTreeLocation;
    }
}

