/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.client.testUtils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import org.junit.Assert;

public class FileUtils {
    public static void copyFiles(File src, File dest) throws IOException {
        if (!src.exists()) {
            return;
        }
        if (src.isDirectory()) {
            dest.mkdirs();
            String[] list = src.list();
            for (int i = 0; i < list.length; ++i) {
                File src1 = new File(src, list[i]);
                File dest1 = new File(dest, list[i]);
                FileUtils.copyFiles(src1, dest1);
            }
        } else {
            FileUtils.copyFile(src, dest);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File src, File dest) throws FileNotFoundException, IOException {
        if (dest.exists()) {
            dest.delete();
        }
        FileInputStream in = null;
        FileOutputStream out = null;
        try {
            in = new FileInputStream(src);
            out = new FileOutputStream(dest);
            byte[] buffer = new byte[8192];
            int count = 0;
            do {
                out.write(buffer, 0, count);
            } while ((count = in.read(buffer, 0, buffer.length)) != -1);
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (in != null) {
                in.close();
            }
        }
    }

    public static void removeDirectoryWithContent(File localTmp) {
        if (localTmp.isDirectory()) {
            File[] content = localTmp.listFiles();
            for (int i = 0; i < content.length; ++i) {
                FileUtils.removeDirectoryWithContent(content[i]);
            }
        }
        localTmp.delete();
    }

    public static File createTempDir(String suffix, String prefix) throws IOException {
        File tmpFile = File.createTempFile("bazaar_client_tests", "");
        tmpFile.delete();
        File tmpDir = new File(tmpFile.getPath());
        tmpDir.mkdirs();
        return tmpDir;
    }

    public static void addContentToFile(File file, String content) throws FileNotFoundException {
        PrintWriter fileWriter = new PrintWriter(new FileOutputStream(file, true));
        fileWriter.print(content);
        fileWriter.close();
    }

    public static void assertWTEqual(File anotherBranch, File branch) {
        String[] newList = branch.list();
        String[] origList = anotherBranch.list();
        for (int i = 0; i < origList.length; ++i) {
            Assert.assertEquals((Object)origList[i], (Object)newList[i]);
        }
    }
}

